@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.inputs

import com.pulumi.aws.imagebuilder.inputs.InfrastructureConfigurationLoggingS3LogsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property s3BucketName Name of the S3 Bucket.
 * The following arguments are optional:
 * @property s3KeyPrefix Prefix to use for S3 logs. Defaults to `/`.
 */
public data class InfrastructureConfigurationLoggingS3LogsArgs(
    public val s3BucketName: Output<String>,
    public val s3KeyPrefix: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.imagebuilder.inputs.InfrastructureConfigurationLoggingS3LogsArgs> {
    override fun toJava():
        com.pulumi.aws.imagebuilder.inputs.InfrastructureConfigurationLoggingS3LogsArgs =
        com.pulumi.aws.imagebuilder.inputs.InfrastructureConfigurationLoggingS3LogsArgs.builder()
            .s3BucketName(s3BucketName.applyValue({ args0 -> args0 }))
            .s3KeyPrefix(s3KeyPrefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InfrastructureConfigurationLoggingS3LogsArgs].
 */
@PulumiTagMarker
public class InfrastructureConfigurationLoggingS3LogsArgsBuilder internal constructor() {
    private var s3BucketName: Output<String>? = null

    private var s3KeyPrefix: Output<String>? = null

    /**
     * @param value Name of the S3 Bucket.
     * The following arguments are optional:
     */
    @JvmName("edewollwdqekelcv")
    public suspend fun s3BucketName(`value`: Output<String>) {
        this.s3BucketName = value
    }

    /**
     * @param value Prefix to use for S3 logs. Defaults to `/`.
     */
    @JvmName("kdeytalbqfjlyxev")
    public suspend fun s3KeyPrefix(`value`: Output<String>) {
        this.s3KeyPrefix = value
    }

    /**
     * @param value Name of the S3 Bucket.
     * The following arguments are optional:
     */
    @JvmName("ecogvacamsfhfstp")
    public suspend fun s3BucketName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3BucketName = mapped
    }

    /**
     * @param value Prefix to use for S3 logs. Defaults to `/`.
     */
    @JvmName("tuitiqikgnaqolqj")
    public suspend fun s3KeyPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3KeyPrefix = mapped
    }

    internal fun build(): InfrastructureConfigurationLoggingS3LogsArgs =
        InfrastructureConfigurationLoggingS3LogsArgs(
            s3BucketName = s3BucketName ?: throw PulumiNullFieldException("s3BucketName"),
            s3KeyPrefix = s3KeyPrefix,
        )
}
