@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property blockDeviceMappings Configuration block(s) with block device mappings for the container recipe. Detailed below.
 * @property image The AMI ID to use as the base image for a container build and test instance. If not specified, Image Builder will use the appropriate ECS-optimized AMI as a base image.
 */
public data class ContainerRecipeInstanceConfiguration(
    public val blockDeviceMappings: List<ContainerRecipeInstanceConfigurationBlockDeviceMapping>? =
        null,
    public val image: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.ContainerRecipeInstanceConfiguration):
            ContainerRecipeInstanceConfiguration = ContainerRecipeInstanceConfiguration(
            blockDeviceMappings = javaType.blockDeviceMappings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.imagebuilder.kotlin.outputs.ContainerRecipeInstanceConfigurationBlockDeviceMapping.Companion.toKotlin(args0)
                })
            }),
            image = javaType.image().map({ args0 -> args0 }).orElse(null),
        )
    }
}
