@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property amiDistributionConfiguration Configuration block with Amazon Machine Image (AMI) distribution settings. Detailed below.
 * @property containerDistributionConfiguration Configuration block with container distribution settings. Detailed below.
 * @property fastLaunchConfigurations Set of Windows faster-launching configurations to use for AMI distribution. Detailed below.
 * @property launchTemplateConfigurations Set of launch template configuration settings that apply to image distribution. Detailed below.
 * @property licenseConfigurationArns Set of Amazon Resource Names (ARNs) of License Manager License Configurations.
 * @property region AWS Region for the distribution.
 * The following arguments are optional:
 */
public data class DistributionConfigurationDistribution(
    public val amiDistributionConfiguration:
    DistributionConfigurationDistributionAmiDistributionConfiguration? = null,
    public val containerDistributionConfiguration:
    DistributionConfigurationDistributionContainerDistributionConfiguration? = null,
    public val fastLaunchConfigurations:
    List<DistributionConfigurationDistributionFastLaunchConfiguration>? = null,
    public val launchTemplateConfigurations:
    List<DistributionConfigurationDistributionLaunchTemplateConfiguration>? = null,
    public val licenseConfigurationArns: List<String>? = null,
    public val region: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.DistributionConfigurationDistribution):
            DistributionConfigurationDistribution = DistributionConfigurationDistribution(
            amiDistributionConfiguration = javaType.amiDistributionConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.imagebuilder.kotlin.outputs.DistributionConfigurationDistributionAmiDistributionConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            containerDistributionConfiguration = javaType.containerDistributionConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.imagebuilder.kotlin.outputs.DistributionConfigurationDistributionContainerDistributionConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            fastLaunchConfigurations = javaType.fastLaunchConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.imagebuilder.kotlin.outputs.DistributionConfigurationDistributionFastLaunchConfiguration.Companion.toKotlin(args0)
                })
            }),
            launchTemplateConfigurations = javaType.launchTemplateConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.imagebuilder.kotlin.outputs.DistributionConfigurationDistributionLaunchTemplateConfiguration.Companion.toKotlin(args0)
                })
            }),
            licenseConfigurationArns = javaType.licenseConfigurationArns().map({ args0 -> args0 }),
            region = javaType.region(),
        )
    }
}
