@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property amiTags Key-value map of tags to apply to the distributed AMI.
 * @property description Description to apply to the distributed AMI.
 * @property kmsKeyId Amazon Resource Name (ARN) of the Key Management Service (KMS) Key to encrypt the distributed AMI.
 * @property launchPermission Configuration block of EC2 launch permissions to apply to the distributed AMI. Detailed below.
 * @property name Name to apply to the distributed AMI.
 * @property targetAccountIds Set of AWS Account identifiers to distribute the AMI.
 */
public data class DistributionConfigurationDistributionAmiDistributionConfiguration(
    public val amiTags: Map<String, String>? = null,
    public val description: String? = null,
    public val kmsKeyId: String? = null,
    public val launchPermission:
    DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermission? = null,
    public val name: String? = null,
    public val targetAccountIds: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.DistributionConfigurationDistributionAmiDistributionConfiguration):
            DistributionConfigurationDistributionAmiDistributionConfiguration =
            DistributionConfigurationDistributionAmiDistributionConfiguration(
                amiTags = javaType.amiTags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                kmsKeyId = javaType.kmsKeyId().map({ args0 -> args0 }).orElse(null),
                launchPermission = javaType.launchPermission().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.imagebuilder.kotlin.outputs.DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermission.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                targetAccountIds = javaType.targetAccountIds().map({ args0 -> args0 }),
            )
    }
}
