@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property organizationArns Set of AWS Organization ARNs to assign.
 * @property organizationalUnitArns Set of AWS Organizational Unit ARNs to assign.
 * @property userGroups Set of EC2 launch permission user groups to assign. Use `all` to distribute a public AMI.
 * @property userIds Set of AWS Account identifiers to assign.
 */
public data class DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermission(
    public val organizationArns: List<String>? = null,
    public val organizationalUnitArns: List<String>? = null,
    public val userGroups: List<String>? = null,
    public val userIds: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermission):
            DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermission =
            DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermission(
                organizationArns = javaType.organizationArns().map({ args0 -> args0 }),
                organizationalUnitArns = javaType.organizationalUnitArns().map({ args0 -> args0 }),
                userGroups = javaType.userGroups().map({ args0 -> args0 }),
                userIds = javaType.userIds().map({ args0 -> args0 }),
            )
    }
}
