@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property launchTemplateId The ID of the launch template to use for faster launching for a Windows AMI.
 * @property launchTemplateName The name of the launch template to use for faster launching for a Windows AMI.
 * @property launchTemplateVersion The version of the launch template to use for faster launching for a Windows AMI.
 */
public data class DistributionConfigurationDistributionFastLaunchConfigurationLaunchTemplate(
    public val launchTemplateId: String? = null,
    public val launchTemplateName: String? = null,
    public val launchTemplateVersion: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.DistributionConfigurationDistributionFastLaunchConfigurationLaunchTemplate):
            DistributionConfigurationDistributionFastLaunchConfigurationLaunchTemplate =
            DistributionConfigurationDistributionFastLaunchConfigurationLaunchTemplate(
                launchTemplateId = javaType.launchTemplateId().map({ args0 -> args0 }).orElse(null),
                launchTemplateName = javaType.launchTemplateName().map({ args0 -> args0 }).orElse(null),
                launchTemplateVersion = javaType.launchTemplateVersion().map({ args0 -> args0 }).orElse(null),
            )
    }
}
