@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getComponent.
 * @property arn
 * @property changeDescription Change description of the component.
 * @property data Data of the component.
 * @property dateCreated Date the component was created.
 * @property description Description of the component.
 * @property encrypted Encryption status of the component.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property kmsKeyId ARN of the Key Management Service (KMS) Key used to encrypt the component.
 * @property name Name of the component.
 * @property owner Owner of the component.
 * @property platform Platform of the component.
 * @property supportedOsVersions Operating Systems (OSes) supported by the component.
 * @property tags Key-value map of resource tags for the component.
 * @property type Type of the component.
 * @property version Version of the component.
 */
public data class GetComponentResult(
    public val arn: String,
    public val changeDescription: String,
    public val `data`: String,
    public val dateCreated: String,
    public val description: String,
    public val encrypted: Boolean,
    public val id: String,
    public val kmsKeyId: String,
    public val name: String,
    public val owner: String,
    public val platform: String,
    public val supportedOsVersions: List<String>,
    public val tags: Map<String, String>,
    public val type: String,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.GetComponentResult):
            GetComponentResult = GetComponentResult(
            arn = javaType.arn(),
            changeDescription = javaType.changeDescription(),
            `data` = javaType.`data`(),
            dateCreated = javaType.dateCreated(),
            description = javaType.description(),
            encrypted = javaType.encrypted(),
            id = javaType.id(),
            kmsKeyId = javaType.kmsKeyId(),
            name = javaType.name(),
            owner = javaType.owner(),
            platform = javaType.platform(),
            supportedOsVersions = javaType.supportedOsVersions().map({ args0 -> args0 }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            version = javaType.version(),
        )
    }
}
