@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property repositoryName Name of the container repository where the output container image is stored. The name is prefixed by the repository location.
 * @property service Service in which this image is registered.
 */
public data class GetContainerRecipeTargetRepository(
    public val repositoryName: String,
    public val service: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.GetContainerRecipeTargetRepository):
            GetContainerRecipeTargetRepository = GetContainerRecipeTargetRepository(
            repositoryName = javaType.repositoryName(),
            service = javaType.service(),
        )
    }
}
