@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property amiDistributionConfigurations Nested list of AMI distribution configuration.
 * @property containerDistributionConfigurations Nested list of container distribution configurations.
 * @property fastLaunchConfigurations Nested list of Windows faster-launching configurations to use for AMI distribution.
 * @property launchTemplateConfigurations Nested list of launch template configurations.
 * @property licenseConfigurationArns Set of Amazon Resource Names (ARNs) of License Manager License Configurations.
 * @property region AWS Region of distribution.
 */
public data class GetDistributionConfigurationDistribution(
    public val amiDistributionConfigurations:
    List<GetDistributionConfigurationDistributionAmiDistributionConfiguration>,
    public val containerDistributionConfigurations:
    List<GetDistributionConfigurationDistributionContainerDistributionConfiguration>,
    public val fastLaunchConfigurations:
    List<GetDistributionConfigurationDistributionFastLaunchConfiguration>,
    public val launchTemplateConfigurations:
    List<GetDistributionConfigurationDistributionLaunchTemplateConfiguration>,
    public val licenseConfigurationArns: List<String>,
    public val region: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.GetDistributionConfigurationDistribution):
            GetDistributionConfigurationDistribution = GetDistributionConfigurationDistribution(
            amiDistributionConfigurations = javaType.amiDistributionConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.imagebuilder.kotlin.outputs.GetDistributionConfigurationDistributionAmiDistributionConfiguration.Companion.toKotlin(args0)
                })
            }),
            containerDistributionConfigurations = javaType.containerDistributionConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.imagebuilder.kotlin.outputs.GetDistributionConfigurationDistributionContainerDistributionConfiguration.Companion.toKotlin(args0)
                })
            }),
            fastLaunchConfigurations = javaType.fastLaunchConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.imagebuilder.kotlin.outputs.GetDistributionConfigurationDistributionFastLaunchConfiguration.Companion.toKotlin(args0)
                })
            }),
            launchTemplateConfigurations = javaType.launchTemplateConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.imagebuilder.kotlin.outputs.GetDistributionConfigurationDistributionLaunchTemplateConfiguration.Companion.toKotlin(args0)
                })
            }),
            licenseConfigurationArns = javaType.licenseConfigurationArns().map({ args0 -> args0 }),
            region = javaType.region(),
        )
    }
}
