@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property amiTags Key-value map of tags to apply to distributed AMI.
 * @property description Description of the container distribution configuration.
 * @property kmsKeyId ARN of Key Management Service (KMS) Key to encrypt AMI.
 * @property launchPermissions Nested list of EC2 launch permissions.
 * @property name Name of the distribution configuration.
 * @property targetAccountIds Set of target AWS Account identifiers.
 */
public data class GetDistributionConfigurationDistributionAmiDistributionConfiguration(
    public val amiTags: Map<String, String>,
    public val description: String,
    public val kmsKeyId: String,
    public val launchPermissions:
    List<GetDistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermission>,
    public val name: String,
    public val targetAccountIds: List<String>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.GetDistributionConfigurationDistributionAmiDistributionConfiguration):
            GetDistributionConfigurationDistributionAmiDistributionConfiguration =
            GetDistributionConfigurationDistributionAmiDistributionConfiguration(
                amiTags = javaType.amiTags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                description = javaType.description(),
                kmsKeyId = javaType.kmsKeyId(),
                launchPermissions = javaType.launchPermissions().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.imagebuilder.kotlin.outputs.GetDistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermission.Companion.toKotlin(args0)
                    })
                }),
                name = javaType.name(),
                targetAccountIds = javaType.targetAccountIds().map({ args0 -> args0 }),
            )
    }
}
