@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property containerTags Set of tags that are attached to the container distribution configuration.
 * @property description Description of the container distribution configuration.
 * @property targetRepositories Set of destination repositories for the container distribution configuration.
 */
public data class GetDistributionConfigurationDistributionContainerDistributionConfiguration(
    public val containerTags: List<String>,
    public val description: String,
    public val targetRepositories:
    List<GetDistributionConfigurationDistributionContainerDistributionConfigurationTargetRepository>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.GetDistributionConfigurationDistributionContainerDistributionConfiguration):
            GetDistributionConfigurationDistributionContainerDistributionConfiguration =
            GetDistributionConfigurationDistributionContainerDistributionConfiguration(
                containerTags = javaType.containerTags().map({ args0 -> args0 }),
                description = javaType.description(),
                targetRepositories = javaType.targetRepositories().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.imagebuilder.kotlin.outputs.GetDistributionConfigurationDistributionContainerDistributionConfigurationTargetRepository.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
