@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property accountId The account ID that this configuration applies to.
 * @property enabled A Boolean that represents the current state of faster launching for the Windows AMI.
 * @property launchTemplates Nested list of launch templates that the fast-launch enabled Windows AMI uses when it launches Windows instances to create pre-provisioned snapshots.
 * @property maxParallelLaunches The maximum number of parallel instances that are launched for creating resources.
 * @property snapshotConfigurations Nested list of configurations for managing the number of snapshots that are created from pre-provisioned instances for the Windows AMI when faster launching is enabled.
 */
public data class GetDistributionConfigurationDistributionFastLaunchConfiguration(
    public val accountId: String,
    public val enabled: Boolean,
    public val launchTemplates:
    List<GetDistributionConfigurationDistributionFastLaunchConfigurationLaunchTemplate>,
    public val maxParallelLaunches: Int,
    public val snapshotConfigurations:
    List<GetDistributionConfigurationDistributionFastLaunchConfigurationSnapshotConfiguration>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.GetDistributionConfigurationDistributionFastLaunchConfiguration):
            GetDistributionConfigurationDistributionFastLaunchConfiguration =
            GetDistributionConfigurationDistributionFastLaunchConfiguration(
                accountId = javaType.accountId(),
                enabled = javaType.enabled(),
                launchTemplates = javaType.launchTemplates().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.imagebuilder.kotlin.outputs.GetDistributionConfigurationDistributionFastLaunchConfigurationLaunchTemplate.Companion.toKotlin(args0)
                    })
                }),
                maxParallelLaunches = javaType.maxParallelLaunches(),
                snapshotConfigurations = javaType.snapshotConfigurations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.imagebuilder.kotlin.outputs.GetDistributionConfigurationDistributionFastLaunchConfigurationSnapshotConfiguration.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
