@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accountId The account ID that this configuration applies to.
 * @property default Whether the specified Amazon EC2 launch template is set as the default launch template.
 * @property launchTemplateId ID of the Amazon EC2 launch template.
 */
public data class GetDistributionConfigurationDistributionLaunchTemplateConfiguration(
    public val accountId: String,
    public val default: Boolean,
    public val launchTemplateId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.GetDistributionConfigurationDistributionLaunchTemplateConfiguration):
            GetDistributionConfigurationDistributionLaunchTemplateConfiguration =
            GetDistributionConfigurationDistributionLaunchTemplateConfiguration(
                accountId = javaType.accountId(),
                default = javaType.default_(),
                launchTemplateId = javaType.launchTemplateId(),
            )
    }
}
