@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getDistributionConfiguration.
 * @property arn
 * @property dateCreated Date the distribution configuration was created.
 * @property dateUpdated Date the distribution configuration was updated.
 * @property description Description of the container distribution configuration.
 * @property distributions Set of distributions.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name Name of the distribution configuration.
 * @property tags Key-value map of resource tags for the distribution configuration.
 */
public data class GetDistributionConfigurationResult(
    public val arn: String,
    public val dateCreated: String,
    public val dateUpdated: String,
    public val description: String,
    public val distributions: List<GetDistributionConfigurationDistribution>,
    public val id: String,
    public val name: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.GetDistributionConfigurationResult):
            GetDistributionConfigurationResult = GetDistributionConfigurationResult(
            arn = javaType.arn(),
            dateCreated = javaType.dateCreated(),
            dateUpdated = javaType.dateUpdated(),
            description = javaType.description(),
            distributions = javaType.distributions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.imagebuilder.kotlin.outputs.GetDistributionConfigurationDistribution.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            name = javaType.name(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
