@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property containerTags Set of tags for Image Builder to apply to the output container image that that Amazon Inspector scans.
 * @property repositoryName The name of the container repository that Amazon Inspector scans to identify findings for your container images.
 */
public data class GetImageImageScanningConfigurationEcrConfiguration(
    public val containerTags: List<String>,
    public val repositoryName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.GetImageImageScanningConfigurationEcrConfiguration):
            GetImageImageScanningConfigurationEcrConfiguration =
            GetImageImageScanningConfigurationEcrConfiguration(
                containerTags = javaType.containerTags().map({ args0 -> args0 }),
                repositoryName = javaType.repositoryName(),
            )
    }
}
