@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accountId Account identifier of the AMI.
 * @property description Description of the AMI.
 * @property image Identifier of the AMI.
 * @property name Name of the AMI.
 * @property region Region of the container image.
 */
public data class GetImageOutputResourceAmi(
    public val accountId: String,
    public val description: String,
    public val image: String,
    public val name: String,
    public val region: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.GetImageOutputResourceAmi):
            GetImageOutputResourceAmi = GetImageOutputResourceAmi(
            accountId = javaType.accountId(),
            description = javaType.description(),
            image = javaType.image(),
            name = javaType.name(),
            region = javaType.region(),
        )
    }
}
