@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property containerTags Tags that are added to the output containers that are scanned
 * @property repositoryName The name of the container repository that Amazon Inspector scans
 */
public data class GetImagePipelineImageScanningConfigurationEcrConfiguration(
    public val containerTags: List<String>,
    public val repositoryName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.GetImagePipelineImageScanningConfigurationEcrConfiguration):
            GetImagePipelineImageScanningConfigurationEcrConfiguration =
            GetImagePipelineImageScanningConfigurationEcrConfiguration(
                containerTags = javaType.containerTags().map({ args0 -> args0 }),
                repositoryName = javaType.repositoryName(),
            )
    }
}
