@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property deleteOnTermination Whether to delete the volume on termination. Defaults to unset, which is the value inherited from the parent image.
 * @property encrypted Whether to encrypt the volume. Defaults to unset, which is the value inherited from the parent image.
 * @property iops Number of Input/Output (I/O) operations per second to provision for an `io1` or `io2` volume.
 * @property kmsKeyId ARN of the Key Management Service (KMS) Key for encryption.
 * @property snapshotId Identifier of the EC2 Volume Snapshot.
 * @property throughput For GP3 volumes only. The throughput in MiB/s that the volume supports.
 * @property volumeSize Size of the volume, in GiB.
 * @property volumeType Type of the volume. For example, `gp2` or `io2`.
 */
public data class GetImageRecipeBlockDeviceMappingEb(
    public val deleteOnTermination: Boolean,
    public val encrypted: Boolean,
    public val iops: Int,
    public val kmsKeyId: String,
    public val snapshotId: String,
    public val throughput: Int,
    public val volumeSize: Int,
    public val volumeType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.GetImageRecipeBlockDeviceMappingEb):
            GetImageRecipeBlockDeviceMappingEb = GetImageRecipeBlockDeviceMappingEb(
            deleteOnTermination = javaType.deleteOnTermination(),
            encrypted = javaType.encrypted(),
            iops = javaType.iops(),
            kmsKeyId = javaType.kmsKeyId(),
            snapshotId = javaType.snapshotId(),
            throughput = javaType.throughput(),
            volumeSize = javaType.volumeSize(),
            volumeType = javaType.volumeType(),
        )
    }
}
