@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property componentArn ARN of the Image Builder Component.
 * @property parameters Set of parameters that are used to configure the component.
 */
public data class GetImageRecipeComponent(
    public val componentArn: String,
    public val parameters: List<GetImageRecipeComponentParameter>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.GetImageRecipeComponent):
            GetImageRecipeComponent = GetImageRecipeComponent(
            componentArn = javaType.componentArn(),
            parameters = javaType.parameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.imagebuilder.kotlin.outputs.GetImageRecipeComponentParameter.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
