@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getImageRecipe.
 * @property arn
 * @property blockDeviceMappings Set of objects with block device mappings for the image recipe.
 * @property components List of objects with components for the image recipe.
 * @property dateCreated Date the image recipe was created.
 * @property description Description of the image recipe.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name Name of the image recipe.
 * @property owner Owner of the image recipe.
 * @property parentImage Base image of the image recipe.
 * @property platform Platform of the image recipe.
 * @property tags Key-value map of resource tags for the image recipe.
 * @property userDataBase64 Base64 encoded contents of user data. Commands or a command script to run when build instance is launched.
 * @property version Version of the image recipe.
 * @property workingDirectory Working directory used during build and test workflows.
 */
public data class GetImageRecipeResult(
    public val arn: String,
    public val blockDeviceMappings: List<GetImageRecipeBlockDeviceMapping>,
    public val components: List<GetImageRecipeComponent>,
    public val dateCreated: String,
    public val description: String,
    public val id: String,
    public val name: String,
    public val owner: String,
    public val parentImage: String,
    public val platform: String,
    public val tags: Map<String, String>? = null,
    public val userDataBase64: String,
    public val version: String,
    public val workingDirectory: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.GetImageRecipeResult):
            GetImageRecipeResult = GetImageRecipeResult(
            arn = javaType.arn(),
            blockDeviceMappings = javaType.blockDeviceMappings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.imagebuilder.kotlin.outputs.GetImageRecipeBlockDeviceMapping.Companion.toKotlin(args0)
                })
            }),
            components = javaType.components().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.imagebuilder.kotlin.outputs.GetImageRecipeComponent.Companion.toKotlin(args0)
                })
            }),
            dateCreated = javaType.dateCreated(),
            description = javaType.description(),
            id = javaType.id(),
            name = javaType.name(),
            owner = javaType.owner(),
            parentImage = javaType.parentImage(),
            platform = javaType.platform(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            userDataBase64 = javaType.userDataBase64(),
            version = javaType.version(),
            workingDirectory = javaType.workingDirectory(),
        )
    }
}
