@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property name Name of the filter field. Valid values can be found in the [Image Builder ListImageRecipes API Reference](https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_ListImageRecipes.html).
 * @property values Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
 */
public data class GetImageRecipesFilter(
    public val name: String,
    public val values: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.GetImageRecipesFilter):
            GetImageRecipesFilter = GetImageRecipesFilter(
            name = javaType.name(),
            values = javaType.values().map({ args0 -> args0 }),
        )
    }
}
