@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getImageRecipes.
 * @property arns Set of ARNs of the matched Image Builder Image Recipes.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property names Set of names of the matched Image Builder Image Recipes.
 * @property owner
 */
public data class GetImageRecipesResult(
    public val arns: List<String>,
    public val filters: List<GetImageRecipesFilter>? = null,
    public val id: String,
    public val names: List<String>,
    public val owner: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.GetImageRecipesResult):
            GetImageRecipesResult = GetImageRecipesResult(
            arns = javaType.arns().map({ args0 -> args0 }),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.imagebuilder.kotlin.outputs.GetImageRecipesFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            names = javaType.names().map({ args0 -> args0 }),
            owner = javaType.owner().map({ args0 -> args0 }).orElse(null),
        )
    }
}
