@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getImage.
 * @property arn
 * @property buildVersionArn Build version ARN of the image. This will always have the `#.#.#/#` suffix.
 * @property containerRecipeArn ARN of the container recipe.
 * @property dateCreated Date the image was created.
 * @property distributionConfigurationArn ARN of the Image Builder Distribution Configuration.
 * @property enhancedImageMetadataEnabled Whether additional information about the image being created is collected.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property imageRecipeArn ARN of the image recipe.
 * @property imageScanningConfigurations List of an object with image scanning configuration fields.
 * @property imageTestsConfigurations List of an object with image tests configuration.
 * @property infrastructureConfigurationArn ARN of the Image Builder Infrastructure Configuration.
 * @property name Name of the AMI.
 * @property osVersion Operating System version of the image.
 * @property outputResources List of objects with resources created by the image.
 * @property platform Platform of the image.
 * @property tags Key-value map of resource tags for the image.
 * @property version Version of the image.
 */
public data class GetImageResult(
    public val arn: String,
    public val buildVersionArn: String,
    public val containerRecipeArn: String,
    public val dateCreated: String,
    public val distributionConfigurationArn: String,
    public val enhancedImageMetadataEnabled: Boolean,
    public val id: String,
    public val imageRecipeArn: String,
    public val imageScanningConfigurations: List<GetImageImageScanningConfiguration>,
    public val imageTestsConfigurations: List<GetImageImageTestsConfiguration>,
    public val infrastructureConfigurationArn: String,
    public val name: String,
    public val osVersion: String,
    public val outputResources: List<GetImageOutputResource>,
    public val platform: String,
    public val tags: Map<String, String>,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.GetImageResult):
            GetImageResult = GetImageResult(
            arn = javaType.arn(),
            buildVersionArn = javaType.buildVersionArn(),
            containerRecipeArn = javaType.containerRecipeArn(),
            dateCreated = javaType.dateCreated(),
            distributionConfigurationArn = javaType.distributionConfigurationArn(),
            enhancedImageMetadataEnabled = javaType.enhancedImageMetadataEnabled(),
            id = javaType.id(),
            imageRecipeArn = javaType.imageRecipeArn(),
            imageScanningConfigurations = javaType.imageScanningConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.imagebuilder.kotlin.outputs.GetImageImageScanningConfiguration.Companion.toKotlin(args0)
                })
            }),
            imageTestsConfigurations = javaType.imageTestsConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.imagebuilder.kotlin.outputs.GetImageImageTestsConfiguration.Companion.toKotlin(args0)
                })
            }),
            infrastructureConfigurationArn = javaType.infrastructureConfigurationArn(),
            name = javaType.name(),
            osVersion = javaType.osVersion(),
            outputResources = javaType.outputResources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.imagebuilder.kotlin.outputs.GetImageOutputResource.Companion.toKotlin(args0)
                })
            }),
            platform = javaType.platform(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            version = javaType.version(),
        )
    }
}
