@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property httpPutResponseHopLimit Number of hops that an instance can traverse to reach its destonation.
 * @property httpTokens Whether a signed token is required for instance metadata retrieval requests.
 */
public data class GetInfrastructureConfigurationInstanceMetadataOption(
    public val httpPutResponseHopLimit: Int,
    public val httpTokens: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.GetInfrastructureConfigurationInstanceMetadataOption):
            GetInfrastructureConfigurationInstanceMetadataOption =
            GetInfrastructureConfigurationInstanceMetadataOption(
                httpPutResponseHopLimit = javaType.httpPutResponseHopLimit(),
                httpTokens = javaType.httpTokens(),
            )
    }
}
