@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property s3BucketName Name of the S3 Bucket for logging.
 * @property s3KeyPrefix Key prefix for S3 Bucket logging.
 */
public data class GetInfrastructureConfigurationLoggingS3Log(
    public val s3BucketName: String,
    public val s3KeyPrefix: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.GetInfrastructureConfigurationLoggingS3Log):
            GetInfrastructureConfigurationLoggingS3Log = GetInfrastructureConfigurationLoggingS3Log(
            s3BucketName = javaType.s3BucketName(),
            s3KeyPrefix = javaType.s3KeyPrefix(),
        )
    }
}
