@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property ecrConfiguration Configuration block with ECR configuration. Detailed below.
 * @property imageScanningEnabled Indicates whether Image Builder keeps a snapshot of the vulnerability scans that Amazon Inspector runs against the build instance when you create a new image. Defaults to `false`.
 */
public data class ImageImageScanningConfiguration(
    public val ecrConfiguration: ImageImageScanningConfigurationEcrConfiguration? = null,
    public val imageScanningEnabled: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.ImageImageScanningConfiguration):
            ImageImageScanningConfiguration = ImageImageScanningConfiguration(
            ecrConfiguration = javaType.ecrConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.imagebuilder.kotlin.outputs.ImageImageScanningConfigurationEcrConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            imageScanningEnabled = javaType.imageScanningEnabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
