@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property imageTestsEnabled Whether image tests are enabled. Defaults to `true`.
 * @property timeoutMinutes Number of minutes before image tests time out. Valid values are between `60` and `1440`. Defaults to `720`.
 */
public data class ImageImageTestsConfiguration(
    public val imageTestsEnabled: Boolean? = null,
    public val timeoutMinutes: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.ImageImageTestsConfiguration):
            ImageImageTestsConfiguration = ImageImageTestsConfiguration(
            imageTestsEnabled = javaType.imageTestsEnabled().map({ args0 -> args0 }).orElse(null),
            timeoutMinutes = javaType.timeoutMinutes().map({ args0 -> args0 }).orElse(null),
        )
    }
}
