@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accountId Account identifier of the AMI.
 * @property description Description of the AMI.
 * @property image Identifier of the AMI.
 * @property name Name of the AMI.
 * @property region Region of the container image.
 */
public data class ImageOutputResourceAmi(
    public val accountId: String? = null,
    public val description: String? = null,
    public val image: String? = null,
    public val name: String? = null,
    public val region: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.ImageOutputResourceAmi):
            ImageOutputResourceAmi = ImageOutputResourceAmi(
            accountId = javaType.accountId().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            image = javaType.image().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            region = javaType.region().map({ args0 -> args0 }).orElse(null),
        )
    }
}
