@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property imageUris Set of URIs for created containers.
 * @property region Region of the container image.
 */
public data class ImageOutputResourceContainer(
    public val imageUris: List<String>? = null,
    public val region: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.ImageOutputResourceContainer):
            ImageOutputResourceContainer = ImageOutputResourceContainer(
            imageUris = javaType.imageUris().map({ args0 -> args0 }),
            region = javaType.region().map({ args0 -> args0 }).orElse(null),
        )
    }
}
