@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property ecrConfiguration Configuration block with ECR configuration for image scanning. Detailed below.
 * @property imageScanningEnabled Whether image scans are enabled. Defaults to `false`.
 */
public data class ImagePipelineImageScanningConfiguration(
    public val ecrConfiguration: ImagePipelineImageScanningConfigurationEcrConfiguration? = null,
    public val imageScanningEnabled: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.ImagePipelineImageScanningConfiguration):
            ImagePipelineImageScanningConfiguration = ImagePipelineImageScanningConfiguration(
            ecrConfiguration = javaType.ecrConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.imagebuilder.kotlin.outputs.ImagePipelineImageScanningConfigurationEcrConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            imageScanningEnabled = javaType.imageScanningEnabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
