@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property httpPutResponseHopLimit The number of hops that an instance can traverse to reach its destonation.
 * @property httpTokens Whether a signed token is required for instance metadata retrieval requests. Valid values: `required`, `optional`.
 */
public data class InfrastructureConfigurationInstanceMetadataOptions(
    public val httpPutResponseHopLimit: Int? = null,
    public val httpTokens: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.InfrastructureConfigurationInstanceMetadataOptions):
            InfrastructureConfigurationInstanceMetadataOptions =
            InfrastructureConfigurationInstanceMetadataOptions(
                httpPutResponseHopLimit = javaType.httpPutResponseHopLimit().map({ args0 -> args0 }).orElse(null),
                httpTokens = javaType.httpTokens().map({ args0 -> args0 }).orElse(null),
            )
    }
}
