@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.inspector.kotlin

import com.pulumi.aws.inspector.AssessmentTemplateArgs.builder
import com.pulumi.aws.inspector.kotlin.inputs.AssessmentTemplateEventSubscriptionArgs
import com.pulumi.aws.inspector.kotlin.inputs.AssessmentTemplateEventSubscriptionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Inspector Classic Assessment Template
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.inspector.AssessmentTemplate;
 * import com.pulumi.aws.inspector.AssessmentTemplateArgs;
 * import com.pulumi.aws.inspector.inputs.AssessmentTemplateEventSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AssessmentTemplate("example", AssessmentTemplateArgs.builder()
 *             .targetArn(aws_inspector_assessment_target.example().arn())
 *             .duration(3600)
 *             .rulesPackageArns(
 *                 "arn:aws:inspector:us-west-2:758058086616:rulespackage/0-9hgA516p",
 *                 "arn:aws:inspector:us-west-2:758058086616:rulespackage/0-H5hpSawc",
 *                 "arn:aws:inspector:us-west-2:758058086616:rulespackage/0-JJOtZiqQ",
 *                 "arn:aws:inspector:us-west-2:758058086616:rulespackage/0-vg5GGHSD")
 *             .eventSubscriptions(AssessmentTemplateEventSubscriptionArgs.builder()
 *                 .event("ASSESSMENT_RUN_COMPLETED")
 *                 .topicArn(aws_sns_topic.example().arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_inspector_assessment_template` using the template assessment ARN. For example:
 * ```sh
 *  $ pulumi import aws:inspector/assessmentTemplate:AssessmentTemplate example arn:aws:inspector:us-west-2:123456789012:target/0-9IaAzhGR/template/0-WEcjR8CH
 * ```
 * @property duration The duration of the inspector run.
 * @property eventSubscriptions A block that enables sending notifications about a specified assessment template event to a designated SNS topic. See Event Subscriptions for details.
 * @property name The name of the assessment template.
 * @property rulesPackageArns The rules to be used during the run.
 * @property tags Key-value map of tags for the Inspector assessment template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property targetArn The assessment target ARN to attach the template to.
 */
public data class AssessmentTemplateArgs(
    public val duration: Output<Int>? = null,
    public val eventSubscriptions: Output<List<AssessmentTemplateEventSubscriptionArgs>>? = null,
    public val name: Output<String>? = null,
    public val rulesPackageArns: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.inspector.AssessmentTemplateArgs> {
    override fun toJava(): com.pulumi.aws.inspector.AssessmentTemplateArgs =
        com.pulumi.aws.inspector.AssessmentTemplateArgs.builder()
            .duration(duration?.applyValue({ args0 -> args0 }))
            .eventSubscriptions(
                eventSubscriptions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .rulesPackageArns(rulesPackageArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetArn(targetArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AssessmentTemplateArgs].
 */
@PulumiTagMarker
public class AssessmentTemplateArgsBuilder internal constructor() {
    private var duration: Output<Int>? = null

    private var eventSubscriptions: Output<List<AssessmentTemplateEventSubscriptionArgs>>? = null

    private var name: Output<String>? = null

    private var rulesPackageArns: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetArn: Output<String>? = null

    /**
     * @param value The duration of the inspector run.
     */
    @JvmName("xcdbqmldfqbsvrss")
    public suspend fun duration(`value`: Output<Int>) {
        this.duration = value
    }

    /**
     * @param value A block that enables sending notifications about a specified assessment template event to a designated SNS topic. See Event Subscriptions for details.
     */
    @JvmName("qindhyprieglcefh")
    public suspend
    fun eventSubscriptions(`value`: Output<List<AssessmentTemplateEventSubscriptionArgs>>) {
        this.eventSubscriptions = value
    }

    @JvmName("wpdqsalulefdgaqv")
    public suspend fun eventSubscriptions(
        vararg
        values: Output<AssessmentTemplateEventSubscriptionArgs>,
    ) {
        this.eventSubscriptions = Output.all(values.asList())
    }

    /**
     * @param values A block that enables sending notifications about a specified assessment template event to a designated SNS topic. See Event Subscriptions for details.
     */
    @JvmName("qkrqvpschmxljbte")
    public suspend
    fun eventSubscriptions(values: List<Output<AssessmentTemplateEventSubscriptionArgs>>) {
        this.eventSubscriptions = Output.all(values)
    }

    /**
     * @param value The name of the assessment template.
     */
    @JvmName("ocsbhhccippmvwtn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The rules to be used during the run.
     */
    @JvmName("fixqxxqvpwfoawxv")
    public suspend fun rulesPackageArns(`value`: Output<List<String>>) {
        this.rulesPackageArns = value
    }

    @JvmName("pykckcravkhhtuxk")
    public suspend fun rulesPackageArns(vararg values: Output<String>) {
        this.rulesPackageArns = Output.all(values.asList())
    }

    /**
     * @param values The rules to be used during the run.
     */
    @JvmName("otwkujvvjvvnelle")
    public suspend fun rulesPackageArns(values: List<Output<String>>) {
        this.rulesPackageArns = Output.all(values)
    }

    /**
     * @param value Key-value map of tags for the Inspector assessment template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vtohlpqsfywuwxfx")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The assessment target ARN to attach the template to.
     */
    @JvmName("entxstqamxpnpmmo")
    public suspend fun targetArn(`value`: Output<String>) {
        this.targetArn = value
    }

    /**
     * @param value The duration of the inspector run.
     */
    @JvmName("rwajevskwyjvqdup")
    public suspend fun duration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.duration = mapped
    }

    /**
     * @param value A block that enables sending notifications about a specified assessment template event to a designated SNS topic. See Event Subscriptions for details.
     */
    @JvmName("ctfntdjfyebydbdo")
    public suspend fun eventSubscriptions(`value`: List<AssessmentTemplateEventSubscriptionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventSubscriptions = mapped
    }

    /**
     * @param argument A block that enables sending notifications about a specified assessment template event to a designated SNS topic. See Event Subscriptions for details.
     */
    @JvmName("fdctqujesvcaqnjo")
    public suspend
    fun eventSubscriptions(argument: List<suspend AssessmentTemplateEventSubscriptionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AssessmentTemplateEventSubscriptionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.eventSubscriptions = mapped
    }

    /**
     * @param argument A block that enables sending notifications about a specified assessment template event to a designated SNS topic. See Event Subscriptions for details.
     */
    @JvmName("jdwhflccbcrkdtor")
    public suspend fun eventSubscriptions(
        vararg
        argument: suspend AssessmentTemplateEventSubscriptionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AssessmentTemplateEventSubscriptionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.eventSubscriptions = mapped
    }

    /**
     * @param argument A block that enables sending notifications about a specified assessment template event to a designated SNS topic. See Event Subscriptions for details.
     */
    @JvmName("rpypfpatcgblmfau")
    public suspend
    fun eventSubscriptions(argument: suspend AssessmentTemplateEventSubscriptionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AssessmentTemplateEventSubscriptionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.eventSubscriptions = mapped
    }

    /**
     * @param values A block that enables sending notifications about a specified assessment template event to a designated SNS topic. See Event Subscriptions for details.
     */
    @JvmName("mcejcjvxtmggacdb")
    public suspend fun eventSubscriptions(vararg values: AssessmentTemplateEventSubscriptionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventSubscriptions = mapped
    }

    /**
     * @param value The name of the assessment template.
     */
    @JvmName("bngopmnrirqoaxaf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The rules to be used during the run.
     */
    @JvmName("nhuiantmnibxaquw")
    public suspend fun rulesPackageArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rulesPackageArns = mapped
    }

    /**
     * @param values The rules to be used during the run.
     */
    @JvmName("wtklvxlnurnyuvbp")
    public suspend fun rulesPackageArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rulesPackageArns = mapped
    }

    /**
     * @param value Key-value map of tags for the Inspector assessment template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pmildupielcaoecj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of tags for the Inspector assessment template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("exfkntxejspbbehu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The assessment target ARN to attach the template to.
     */
    @JvmName("nhcrowmluoxmbrcd")
    public suspend fun targetArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetArn = mapped
    }

    internal fun build(): AssessmentTemplateArgs = AssessmentTemplateArgs(
        duration = duration,
        eventSubscriptions = eventSubscriptions,
        name = name,
        rulesPackageArns = rulesPackageArns,
        tags = tags,
        targetArn = targetArn,
    )
}
