@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.inspector.kotlin

import com.pulumi.aws.inspector.InspectorFunctions.getRulesPackagesPlain
import com.pulumi.aws.inspector.kotlin.outputs.GetRulesPackagesResult
import com.pulumi.aws.inspector.kotlin.outputs.GetRulesPackagesResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.Suppress

public object InspectorFunctions {
    /**
     * The Amazon Inspector Classic Rules Packages data source allows access to the list of AWS
     * Inspector Rules Packages which can be used by Amazon Inspector Classic within the region
     * configured in the provider.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.inspector.InspectorFunctions;
     * import com.pulumi.aws.inspector.ResourceGroup;
     * import com.pulumi.aws.inspector.ResourceGroupArgs;
     * import com.pulumi.aws.inspector.AssessmentTarget;
     * import com.pulumi.aws.inspector.AssessmentTargetArgs;
     * import com.pulumi.aws.inspector.AssessmentTemplate;
     * import com.pulumi.aws.inspector.AssessmentTemplateArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var rules = InspectorFunctions.getRulesPackages();
     *         var group = new ResourceGroup("group", ResourceGroupArgs.builder()
     *             .tags(Map.of("test", "test"))
     *             .build());
     *         var assessmentAssessmentTarget = new AssessmentTarget("assessmentAssessmentTarget", AssessmentTargetArgs.builder()
     *             .resourceGroupArn(group.arn())
     *             .build());
     *         var assessmentAssessmentTemplate = new AssessmentTemplate("assessmentAssessmentTemplate", AssessmentTemplateArgs.builder()
     *             .targetArn(assessmentAssessmentTarget.arn())
     *             .duration("60")
     *             .rulesPackageArns(rules.applyValue(getRulesPackagesResult -> getRulesPackagesResult.arns()))
     *             .build());
     *     }
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.inspector.InspectorFunctions;
     * import com.pulumi.aws.inspector.ResourceGroup;
     * import com.pulumi.aws.inspector.ResourceGroupArgs;
     * import com.pulumi.aws.inspector.AssessmentTarget;
     * import com.pulumi.aws.inspector.AssessmentTargetArgs;
     * import com.pulumi.aws.inspector.AssessmentTemplate;
     * import com.pulumi.aws.inspector.AssessmentTemplateArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var rules = InspectorFunctions.getRulesPackages();
     *         var group = new ResourceGroup("group", ResourceGroupArgs.builder()
     *             .tags(Map.of("test", "test"))
     *             .build());
     *         var assessmentAssessmentTarget = new AssessmentTarget("assessmentAssessmentTarget", AssessmentTargetArgs.builder()
     *             .resourceGroupArn(group.arn())
     *             .build());
     *         var assessmentAssessmentTemplate = new AssessmentTemplate("assessmentAssessmentTemplate", AssessmentTemplateArgs.builder()
     *             .targetArn(assessmentAssessmentTarget.arn())
     *             .duration("60")
     *             .rulesPackageArns(rules.applyValue(getRulesPackagesResult -> getRulesPackagesResult.arns()))
     *             .build());
     *     }
     * }
     * ```
     * @param argument The Amazon Inspector Classic Rules Packages data source allows access to the list of AWS
     * Inspector Rules Packages which can be used by Amazon Inspector Classic within the region
     * configured in the provider.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.inspector.InspectorFunctions;
     * import com.pulumi.aws.inspector.ResourceGroup;
     * import com.pulumi.aws.inspector.ResourceGroupArgs;
     * import com.pulumi.aws.inspector.AssessmentTarget;
     * import com.pulumi.aws.inspector.AssessmentTargetArgs;
     * import com.pulumi.aws.inspector.AssessmentTemplate;
     * import com.pulumi.aws.inspector.AssessmentTemplateArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var rules = InspectorFunctions.getRulesPackages();
     *         var group = new ResourceGroup("group", ResourceGroupArgs.builder()
     *             .tags(Map.of("test", "test"))
     *             .build());
     *         var assessmentAssessmentTarget = new AssessmentTarget("assessmentAssessmentTarget", AssessmentTargetArgs.builder()
     *             .resourceGroupArn(group.arn())
     *             .build());
     *         var assessmentAssessmentTemplate = new AssessmentTemplate("assessmentAssessmentTemplate", AssessmentTemplateArgs.builder()
     *             .targetArn(assessmentAssessmentTarget.arn())
     *             .duration("60")
     *             .rulesPackageArns(rules.applyValue(getRulesPackagesResult -> getRulesPackagesResult.arns()))
     *             .build());
     *     }
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.inspector.InspectorFunctions;
     * import com.pulumi.aws.inspector.ResourceGroup;
     * import com.pulumi.aws.inspector.ResourceGroupArgs;
     * import com.pulumi.aws.inspector.AssessmentTarget;
     * import com.pulumi.aws.inspector.AssessmentTargetArgs;
     * import com.pulumi.aws.inspector.AssessmentTemplate;
     * import com.pulumi.aws.inspector.AssessmentTemplateArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var rules = InspectorFunctions.getRulesPackages();
     *         var group = new ResourceGroup("group", ResourceGroupArgs.builder()
     *             .tags(Map.of("test", "test"))
     *             .build());
     *         var assessmentAssessmentTarget = new AssessmentTarget("assessmentAssessmentTarget", AssessmentTargetArgs.builder()
     *             .resourceGroupArn(group.arn())
     *             .build());
     *         var assessmentAssessmentTemplate = new AssessmentTemplate("assessmentAssessmentTemplate", AssessmentTemplateArgs.builder()
     *             .targetArn(assessmentAssessmentTarget.arn())
     *             .duration("60")
     *             .rulesPackageArns(rules.applyValue(getRulesPackagesResult -> getRulesPackagesResult.arns()))
     *             .build());
     *     }
     * }
     * ```
     * @return A collection of values returned by getRulesPackages.
     */
    public suspend fun getRulesPackages(): GetRulesPackagesResult =
        toKotlin(getRulesPackagesPlain().await())
}
