@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.inspector.kotlin

import com.pulumi.aws.inspector.ResourceGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Amazon Inspector Classic Resource Group.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.inspector.ResourceGroup;
 * import com.pulumi.aws.inspector.ResourceGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResourceGroup("example", ResourceGroupArgs.builder()
 *             .tags(Map.ofEntries(
 *                 Map.entry("Env", "bar"),
 *                 Map.entry("Name", "foo")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * @property tags Key-value map of tags that are used to select the EC2 instances to be included in an Amazon Inspector assessment target.
 */
public data class ResourceGroupArgs(
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.inspector.ResourceGroupArgs> {
    override fun toJava(): com.pulumi.aws.inspector.ResourceGroupArgs =
        com.pulumi.aws.inspector.ResourceGroupArgs.builder()
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ResourceGroupArgs].
 */
@PulumiTagMarker
public class ResourceGroupArgsBuilder internal constructor() {
    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Key-value map of tags that are used to select the EC2 instances to be included in an Amazon Inspector assessment target.
     */
    @JvmName("vpijhgymkpqgurwr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Key-value map of tags that are used to select the EC2 instances to be included in an Amazon Inspector assessment target.
     */
    @JvmName("qkonmhqxqhvhodem")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of tags that are used to select the EC2 instances to be included in an Amazon Inspector assessment target.
     */
    @JvmName("twgywemrayiwaaaf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ResourceGroupArgs = ResourceGroupArgs(
        tags = tags,
    )
}
