@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.inspector.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getRulesPackages.
 * @property arns List of the Amazon Inspector Classic Rules Packages arns available in the AWS region.
 * @property id The provider-assigned unique ID for this managed resource.
 */
public data class GetRulesPackagesResult(
    public val arns: List<String>,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.inspector.outputs.GetRulesPackagesResult):
            GetRulesPackagesResult = GetRulesPackagesResult(
            arns = javaType.arns().map({ args0 -> args0 }),
            id = javaType.id(),
        )
    }
}
