@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.inspector2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DelegatedAdminAccount].
 */
@PulumiTagMarker
public class DelegatedAdminAccountResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DelegatedAdminAccountArgs = DelegatedAdminAccountArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DelegatedAdminAccountArgsBuilder.() -> Unit) {
        val builder = DelegatedAdminAccountArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DelegatedAdminAccount {
        val builtJavaResource = com.pulumi.aws.inspector2.DelegatedAdminAccount(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DelegatedAdminAccount(builtJavaResource)
    }
}

/**
 * Resource for managing an Amazon Inspector Delegated Admin Account.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.inspector2.DelegatedAdminAccount;
 * import com.pulumi.aws.inspector2.DelegatedAdminAccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         var example = new DelegatedAdminAccount("example", DelegatedAdminAccountArgs.builder()
 *             .accountId(current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Inspector Delegated Admin Account using the `account_id`. For example:
 * ```sh
 *  $ pulumi import aws:inspector2/delegatedAdminAccount:DelegatedAdminAccount example 012345678901
 * ```
 *
 */
public class DelegatedAdminAccount internal constructor(
    override val javaResource: com.pulumi.aws.inspector2.DelegatedAdminAccount,
) : KotlinCustomResource(javaResource, DelegatedAdminAccountMapper) {
    /**
     * Account to enable as delegated admin account.
     */
    public val accountId: Output<String>
        get() = javaResource.accountId().applyValue({ args0 -> args0 })

    /**
     * Status of this delegated admin account.
     */
    public val relationshipStatus: Output<String>
        get() = javaResource.relationshipStatus().applyValue({ args0 -> args0 })
}

public object DelegatedAdminAccountMapper : ResourceMapper<DelegatedAdminAccount> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.inspector2.DelegatedAdminAccount::class == javaResource::class

    override fun map(javaResource: Resource): DelegatedAdminAccount =
        DelegatedAdminAccount(javaResource as com.pulumi.aws.inspector2.DelegatedAdminAccount)
}

/**
 * @see [DelegatedAdminAccount].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DelegatedAdminAccount].
 */
public suspend fun delegatedAdminAccount(
    name: String,
    block: suspend DelegatedAdminAccountResourceBuilder.() -> Unit,
): DelegatedAdminAccount {
    val builder = DelegatedAdminAccountResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DelegatedAdminAccount].
 * @param name The _unique_ name of the resulting resource.
 */
public fun delegatedAdminAccount(name: String): DelegatedAdminAccount {
    val builder = DelegatedAdminAccountResourceBuilder()
    builder.name(name)
    return builder.build()
}
