@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.inspector2.kotlin

import com.pulumi.aws.inspector2.DelegatedAdminAccountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an Amazon Inspector Delegated Admin Account.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.inspector2.DelegatedAdminAccount;
 * import com.pulumi.aws.inspector2.DelegatedAdminAccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         var example = new DelegatedAdminAccount("example", DelegatedAdminAccountArgs.builder()
 *             .accountId(current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Inspector Delegated Admin Account using the `account_id`. For example:
 * ```sh
 *  $ pulumi import aws:inspector2/delegatedAdminAccount:DelegatedAdminAccount example 012345678901
 * ```
 * @property accountId Account to enable as delegated admin account.
 */
public data class DelegatedAdminAccountArgs(
    public val accountId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.inspector2.DelegatedAdminAccountArgs> {
    override fun toJava(): com.pulumi.aws.inspector2.DelegatedAdminAccountArgs =
        com.pulumi.aws.inspector2.DelegatedAdminAccountArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DelegatedAdminAccountArgs].
 */
@PulumiTagMarker
public class DelegatedAdminAccountArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    /**
     * @param value Account to enable as delegated admin account.
     */
    @JvmName("utlgnmqkvnlcpuur")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value Account to enable as delegated admin account.
     */
    @JvmName("ugufxhfbynresprj")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    internal fun build(): DelegatedAdminAccountArgs = DelegatedAdminAccountArgs(
        accountId = accountId,
    )
}
