@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.inspector2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Enabler].
 */
@PulumiTagMarker
public class EnablerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EnablerArgs = EnablerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EnablerArgsBuilder.() -> Unit) {
        val builder = EnablerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Enabler {
        val builtJavaResource = com.pulumi.aws.inspector2.Enabler(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Enabler(builtJavaResource)
    }
}

/**
 * Resource for enabling Amazon Inspector resource scans.
 * This resource must be created in the Organization's Administrator Account.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.inspector2.Enabler;
 * import com.pulumi.aws.inspector2.EnablerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Enabler("example", EnablerArgs.builder()
 *             .accountIds("123456789012")
 *             .resourceTypes("EC2")
 *             .build());
 *     }
 * }
 * ```
 * ### For the Calling Account
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.inspector2.Enabler;
 * import com.pulumi.aws.inspector2.EnablerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         var test = new Enabler("test", EnablerArgs.builder()
 *             .accountIds(current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *             .resourceTypes(
 *                 "ECR",
 *                 "EC2")
 *             .build());
 *     }
 * }
 * ```
 */
public class Enabler internal constructor(
    override val javaResource: com.pulumi.aws.inspector2.Enabler,
) : KotlinCustomResource(javaResource, EnablerMapper) {
    /**
     * Set of account IDs.
     * Can contain one of: the Organization's Administrator Account, or one or more Member Accounts.
     */
    public val accountIds: Output<List<String>>
        get() = javaResource.accountIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Type of resources to scan.
     * Valid values are `EC2`, `ECR`, `LAMBDA` and `LAMBDA_CODE`.
     * At least one item is required.
     */
    public val resourceTypes: Output<List<String>>
        get() = javaResource.resourceTypes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object EnablerMapper : ResourceMapper<Enabler> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.inspector2.Enabler::class == javaResource::class

    override fun map(javaResource: Resource): Enabler = Enabler(
        javaResource as
            com.pulumi.aws.inspector2.Enabler,
    )
}

/**
 * @see [Enabler].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Enabler].
 */
public suspend fun enabler(name: String, block: suspend EnablerResourceBuilder.() -> Unit):
    Enabler {
    val builder = EnablerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Enabler].
 * @param name The _unique_ name of the resulting resource.
 */
public fun enabler(name: String): Enabler {
    val builder = EnablerResourceBuilder()
    builder.name(name)
    return builder.build()
}
