@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.inspector2.kotlin

import com.pulumi.aws.inspector2.EnablerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Resource for enabling Amazon Inspector resource scans.
 * This resource must be created in the Organization's Administrator Account.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.inspector2.Enabler;
 * import com.pulumi.aws.inspector2.EnablerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Enabler("example", EnablerArgs.builder()
 *             .accountIds("123456789012")
 *             .resourceTypes("EC2")
 *             .build());
 *     }
 * }
 * ```
 * ### For the Calling Account
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.inspector2.Enabler;
 * import com.pulumi.aws.inspector2.EnablerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         var test = new Enabler("test", EnablerArgs.builder()
 *             .accountIds(current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *             .resourceTypes(
 *                 "ECR",
 *                 "EC2")
 *             .build());
 *     }
 * }
 * ```
 * @property accountIds Set of account IDs.
 * Can contain one of: the Organization's Administrator Account, or one or more Member Accounts.
 * @property resourceTypes Type of resources to scan.
 * Valid values are `EC2`, `ECR`, `LAMBDA` and `LAMBDA_CODE`.
 * At least one item is required.
 */
public data class EnablerArgs(
    public val accountIds: Output<List<String>>? = null,
    public val resourceTypes: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.inspector2.EnablerArgs> {
    override fun toJava(): com.pulumi.aws.inspector2.EnablerArgs =
        com.pulumi.aws.inspector2.EnablerArgs.builder()
            .accountIds(accountIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceTypes(resourceTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [EnablerArgs].
 */
@PulumiTagMarker
public class EnablerArgsBuilder internal constructor() {
    private var accountIds: Output<List<String>>? = null

    private var resourceTypes: Output<List<String>>? = null

    /**
     * @param value Set of account IDs.
     * Can contain one of: the Organization's Administrator Account, or one or more Member Accounts.
     */
    @JvmName("flsteswavwbbvtja")
    public suspend fun accountIds(`value`: Output<List<String>>) {
        this.accountIds = value
    }

    @JvmName("xywstxymheemtbda")
    public suspend fun accountIds(vararg values: Output<String>) {
        this.accountIds = Output.all(values.asList())
    }

    /**
     * @param values Set of account IDs.
     * Can contain one of: the Organization's Administrator Account, or one or more Member Accounts.
     */
    @JvmName("kgqfdaofleonlifg")
    public suspend fun accountIds(values: List<Output<String>>) {
        this.accountIds = Output.all(values)
    }

    /**
     * @param value Type of resources to scan.
     * Valid values are `EC2`, `ECR`, `LAMBDA` and `LAMBDA_CODE`.
     * At least one item is required.
     */
    @JvmName("rbyqujsyylxoholn")
    public suspend fun resourceTypes(`value`: Output<List<String>>) {
        this.resourceTypes = value
    }

    @JvmName("vwbefehdmtaryyog")
    public suspend fun resourceTypes(vararg values: Output<String>) {
        this.resourceTypes = Output.all(values.asList())
    }

    /**
     * @param values Type of resources to scan.
     * Valid values are `EC2`, `ECR`, `LAMBDA` and `LAMBDA_CODE`.
     * At least one item is required.
     */
    @JvmName("fmcstcmiisbfjemu")
    public suspend fun resourceTypes(values: List<Output<String>>) {
        this.resourceTypes = Output.all(values)
    }

    /**
     * @param value Set of account IDs.
     * Can contain one of: the Organization's Administrator Account, or one or more Member Accounts.
     */
    @JvmName("ykpqqmlllutgurkl")
    public suspend fun accountIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountIds = mapped
    }

    /**
     * @param values Set of account IDs.
     * Can contain one of: the Organization's Administrator Account, or one or more Member Accounts.
     */
    @JvmName("gfygckagffwdtlbw")
    public suspend fun accountIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountIds = mapped
    }

    /**
     * @param value Type of resources to scan.
     * Valid values are `EC2`, `ECR`, `LAMBDA` and `LAMBDA_CODE`.
     * At least one item is required.
     */
    @JvmName("bfdhdkylpnpetfxm")
    public suspend fun resourceTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceTypes = mapped
    }

    /**
     * @param values Type of resources to scan.
     * Valid values are `EC2`, `ECR`, `LAMBDA` and `LAMBDA_CODE`.
     * At least one item is required.
     */
    @JvmName("ilgqrgccujsdlldq")
    public suspend fun resourceTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTypes = mapped
    }

    internal fun build(): EnablerArgs = EnablerArgs(
        accountIds = accountIds,
        resourceTypes = resourceTypes,
    )
}
