@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.inspector2.kotlin

import com.pulumi.aws.inspector2.MemberAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for associating accounts to existing Inspector instances.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.inspector2.MemberAssociation;
 * import com.pulumi.aws.inspector2.MemberAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new MemberAssociation("example", MemberAssociationArgs.builder()
 *             .accountId("123456789012")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Amazon Inspector Member Association using the `account_id`. For example:
 * ```sh
 *  $ pulumi import aws:inspector2/memberAssociation:MemberAssociation example 123456789012
 * ```
 * @property accountId ID of the account to associate
 */
public data class MemberAssociationArgs(
    public val accountId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.inspector2.MemberAssociationArgs> {
    override fun toJava(): com.pulumi.aws.inspector2.MemberAssociationArgs =
        com.pulumi.aws.inspector2.MemberAssociationArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MemberAssociationArgs].
 */
@PulumiTagMarker
public class MemberAssociationArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    /**
     * @param value ID of the account to associate
     */
    @JvmName("gyxmaamooxvlebug")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value ID of the account to associate
     */
    @JvmName("jsvoqgbxrdnlhcqv")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    internal fun build(): MemberAssociationArgs = MemberAssociationArgs(
        accountId = accountId,
    )
}
