@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.inspector2.kotlin

import com.pulumi.aws.inspector2.OrganizationConfigurationArgs.builder
import com.pulumi.aws.inspector2.kotlin.inputs.OrganizationConfigurationAutoEnableArgs
import com.pulumi.aws.inspector2.kotlin.inputs.OrganizationConfigurationAutoEnableArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Resource for managing an Amazon Inspector Organization Configuration.
 * > **NOTE:** In order for this resource to work, the account you use must be an Inspector Delegated Admin Account.
 * > **NOTE:** When this resource is deleted, EC2, ECR, Lambda, and Lambda code scans will no longer be automatically enabled for new members of your Amazon Inspector organization.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.inspector2.OrganizationConfiguration;
 * import com.pulumi.aws.inspector2.OrganizationConfigurationArgs;
 * import com.pulumi.aws.inspector2.inputs.OrganizationConfigurationAutoEnableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new OrganizationConfiguration("example", OrganizationConfigurationArgs.builder()
 *             .autoEnable(OrganizationConfigurationAutoEnableArgs.builder()
 *                 .ec2(true)
 *                 .ecr(false)
 *                 .lambda(true)
 *                 .lambdaCode(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * @property autoEnable Configuration block for auto enabling. See below.
 */
public data class OrganizationConfigurationArgs(
    public val autoEnable: Output<OrganizationConfigurationAutoEnableArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.inspector2.OrganizationConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.inspector2.OrganizationConfigurationArgs =
        com.pulumi.aws.inspector2.OrganizationConfigurationArgs.builder()
            .autoEnable(autoEnable?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [OrganizationConfigurationArgs].
 */
@PulumiTagMarker
public class OrganizationConfigurationArgsBuilder internal constructor() {
    private var autoEnable: Output<OrganizationConfigurationAutoEnableArgs>? = null

    /**
     * @param value Configuration block for auto enabling. See below.
     */
    @JvmName("umiuxghysvvpqhxl")
    public suspend fun autoEnable(`value`: Output<OrganizationConfigurationAutoEnableArgs>) {
        this.autoEnable = value
    }

    /**
     * @param value Configuration block for auto enabling. See below.
     */
    @JvmName("ycntmktnnyhpmpld")
    public suspend fun autoEnable(`value`: OrganizationConfigurationAutoEnableArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoEnable = mapped
    }

    /**
     * @param argument Configuration block for auto enabling. See below.
     */
    @JvmName("iyqomsrcrjrwjjms")
    public suspend
    fun autoEnable(argument: suspend OrganizationConfigurationAutoEnableArgsBuilder.() -> Unit) {
        val toBeMapped = OrganizationConfigurationAutoEnableArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.autoEnable = mapped
    }

    internal fun build(): OrganizationConfigurationArgs = OrganizationConfigurationArgs(
        autoEnable = autoEnable,
    )
}
