@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Authorizer].
 */
@PulumiTagMarker
public class AuthorizerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AuthorizerArgs = AuthorizerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AuthorizerArgsBuilder.() -> Unit) {
        val builder = AuthorizerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Authorizer {
        val builtJavaResource = com.pulumi.aws.iot.Authorizer(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Authorizer(builtJavaResource)
    }
}

/**
 * Creates and manages an AWS IoT Authorizer.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.Authorizer;
 * import com.pulumi.aws.iot.AuthorizerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Authorizer("example", AuthorizerArgs.builder()
 *             .authorizerFunctionArn(aws_lambda_function.example().arn())
 *             .signingDisabled(false)
 *             .status("ACTIVE")
 *             .tokenKeyName("Token-Header")
 *             .tokenSigningPublicKeys(Map.of("Key1", Files.readString(Paths.get("test-fixtures/iot-authorizer-signing-key.pem"))))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IOT Authorizers using the name. For example:
 * ```sh
 *  $ pulumi import aws:iot/authorizer:Authorizer example example
 * ```
 *
 */
public class Authorizer internal constructor(
    override val javaResource: com.pulumi.aws.iot.Authorizer,
) : KotlinCustomResource(javaResource, AuthorizerMapper) {
    /**
     * The ARN of the authorizer.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The ARN of the authorizer's Lambda function.
     */
    public val authorizerFunctionArn: Output<String>
        get() = javaResource.authorizerFunctionArn().applyValue({ args0 -> args0 })

    /**
     * Specifies whether the HTTP caching is enabled or not. Default: `false`.
     */
    public val enableCachingForHttp: Output<Boolean>?
        get() = javaResource.enableCachingForHttp().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the authorizer.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies whether AWS IoT validates the token signature in an authorization request. Default: `false`.
     */
    public val signingDisabled: Output<Boolean>?
        get() = javaResource.signingDisabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of Authorizer request at creation. Valid values: `ACTIVE`, `INACTIVE`. Default: `ACTIVE`.
     */
    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the token key used to extract the token from the HTTP headers. This value is required if signing is enabled in your authorizer.
     */
    public val tokenKeyName: Output<String>?
        get() = javaResource.tokenKeyName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The public keys used to verify the digital signature returned by your custom authentication service. This value is required if signing is enabled in your authorizer.
     */
    public val tokenSigningPublicKeys: Output<Map<String, String>>?
        get() = javaResource.tokenSigningPublicKeys().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })
}

public object AuthorizerMapper : ResourceMapper<Authorizer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iot.Authorizer::class == javaResource::class

    override fun map(javaResource: Resource): Authorizer = Authorizer(
        javaResource as
            com.pulumi.aws.iot.Authorizer,
    )
}

/**
 * @see [Authorizer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Authorizer].
 */
public suspend fun authorizer(name: String, block: suspend AuthorizerResourceBuilder.() -> Unit):
    Authorizer {
    val builder = AuthorizerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Authorizer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun authorizer(name: String): Authorizer {
    val builder = AuthorizerResourceBuilder()
    builder.name(name)
    return builder.build()
}
