@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.AuthorizerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates and manages an AWS IoT Authorizer.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.Authorizer;
 * import com.pulumi.aws.iot.AuthorizerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Authorizer("example", AuthorizerArgs.builder()
 *             .authorizerFunctionArn(aws_lambda_function.example().arn())
 *             .signingDisabled(false)
 *             .status("ACTIVE")
 *             .tokenKeyName("Token-Header")
 *             .tokenSigningPublicKeys(Map.of("Key1", Files.readString(Paths.get("test-fixtures/iot-authorizer-signing-key.pem"))))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IOT Authorizers using the name. For example:
 * ```sh
 *  $ pulumi import aws:iot/authorizer:Authorizer example example
 * ```
 * @property authorizerFunctionArn The ARN of the authorizer's Lambda function.
 * @property enableCachingForHttp Specifies whether the HTTP caching is enabled or not. Default: `false`.
 * @property name The name of the authorizer.
 * @property signingDisabled Specifies whether AWS IoT validates the token signature in an authorization request. Default: `false`.
 * @property status The status of Authorizer request at creation. Valid values: `ACTIVE`, `INACTIVE`. Default: `ACTIVE`.
 * @property tokenKeyName The name of the token key used to extract the token from the HTTP headers. This value is required if signing is enabled in your authorizer.
 * @property tokenSigningPublicKeys The public keys used to verify the digital signature returned by your custom authentication service. This value is required if signing is enabled in your authorizer.
 */
public data class AuthorizerArgs(
    public val authorizerFunctionArn: Output<String>? = null,
    public val enableCachingForHttp: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val signingDisabled: Output<Boolean>? = null,
    public val status: Output<String>? = null,
    public val tokenKeyName: Output<String>? = null,
    public val tokenSigningPublicKeys: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.AuthorizerArgs> {
    override fun toJava(): com.pulumi.aws.iot.AuthorizerArgs =
        com.pulumi.aws.iot.AuthorizerArgs.builder()
            .authorizerFunctionArn(authorizerFunctionArn?.applyValue({ args0 -> args0 }))
            .enableCachingForHttp(enableCachingForHttp?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .signingDisabled(signingDisabled?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .tokenKeyName(tokenKeyName?.applyValue({ args0 -> args0 }))
            .tokenSigningPublicKeys(
                tokenSigningPublicKeys?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AuthorizerArgs].
 */
@PulumiTagMarker
public class AuthorizerArgsBuilder internal constructor() {
    private var authorizerFunctionArn: Output<String>? = null

    private var enableCachingForHttp: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var signingDisabled: Output<Boolean>? = null

    private var status: Output<String>? = null

    private var tokenKeyName: Output<String>? = null

    private var tokenSigningPublicKeys: Output<Map<String, String>>? = null

    /**
     * @param value The ARN of the authorizer's Lambda function.
     */
    @JvmName("bmeaqwdelouemjyf")
    public suspend fun authorizerFunctionArn(`value`: Output<String>) {
        this.authorizerFunctionArn = value
    }

    /**
     * @param value Specifies whether the HTTP caching is enabled or not. Default: `false`.
     */
    @JvmName("klcfhlfewesjsxrb")
    public suspend fun enableCachingForHttp(`value`: Output<Boolean>) {
        this.enableCachingForHttp = value
    }

    /**
     * @param value The name of the authorizer.
     */
    @JvmName("iivfvlqrudvbcgds")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies whether AWS IoT validates the token signature in an authorization request. Default: `false`.
     */
    @JvmName("nttwfiaqpjtcrkpl")
    public suspend fun signingDisabled(`value`: Output<Boolean>) {
        this.signingDisabled = value
    }

    /**
     * @param value The status of Authorizer request at creation. Valid values: `ACTIVE`, `INACTIVE`. Default: `ACTIVE`.
     */
    @JvmName("mdgpsvftskcxyvup")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The name of the token key used to extract the token from the HTTP headers. This value is required if signing is enabled in your authorizer.
     */
    @JvmName("irmhaijrjimofybo")
    public suspend fun tokenKeyName(`value`: Output<String>) {
        this.tokenKeyName = value
    }

    /**
     * @param value The public keys used to verify the digital signature returned by your custom authentication service. This value is required if signing is enabled in your authorizer.
     */
    @JvmName("vcsrmajidnlnxtym")
    public suspend fun tokenSigningPublicKeys(`value`: Output<Map<String, String>>) {
        this.tokenSigningPublicKeys = value
    }

    /**
     * @param value The ARN of the authorizer's Lambda function.
     */
    @JvmName("kcjtcgvaqdsdklcg")
    public suspend fun authorizerFunctionArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizerFunctionArn = mapped
    }

    /**
     * @param value Specifies whether the HTTP caching is enabled or not. Default: `false`.
     */
    @JvmName("dccdmthgwndwxomn")
    public suspend fun enableCachingForHttp(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableCachingForHttp = mapped
    }

    /**
     * @param value The name of the authorizer.
     */
    @JvmName("fiqsuwjygohyrwnc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies whether AWS IoT validates the token signature in an authorization request. Default: `false`.
     */
    @JvmName("ycehkqanwkuihbkl")
    public suspend fun signingDisabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.signingDisabled = mapped
    }

    /**
     * @param value The status of Authorizer request at creation. Valid values: `ACTIVE`, `INACTIVE`. Default: `ACTIVE`.
     */
    @JvmName("sgnqlslpurpixenf")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The name of the token key used to extract the token from the HTTP headers. This value is required if signing is enabled in your authorizer.
     */
    @JvmName("isovhhnruhacyrny")
    public suspend fun tokenKeyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tokenKeyName = mapped
    }

    /**
     * @param value The public keys used to verify the digital signature returned by your custom authentication service. This value is required if signing is enabled in your authorizer.
     */
    @JvmName("lxpbfpbtpkhxldhp")
    public suspend fun tokenSigningPublicKeys(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tokenSigningPublicKeys = mapped
    }

    /**
     * @param values The public keys used to verify the digital signature returned by your custom authentication service. This value is required if signing is enabled in your authorizer.
     */
    @JvmName("edgfhadiiavuwprf")
    public fun tokenSigningPublicKeys(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tokenSigningPublicKeys = mapped
    }

    internal fun build(): AuthorizerArgs = AuthorizerArgs(
        authorizerFunctionArn = authorizerFunctionArn,
        enableCachingForHttp = enableCachingForHttp,
        name = name,
        signingDisabled = signingDisabled,
        status = status,
        tokenKeyName = tokenKeyName,
        tokenSigningPublicKeys = tokenSigningPublicKeys,
    )
}
