@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.BillingGroupArgs.builder
import com.pulumi.aws.iot.kotlin.inputs.BillingGroupPropertiesArgs
import com.pulumi.aws.iot.kotlin.inputs.BillingGroupPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an AWS IoT Billing Group.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.BillingGroup;
 * import com.pulumi.aws.iot.BillingGroupArgs;
 * import com.pulumi.aws.iot.inputs.BillingGroupPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BillingGroup("example", BillingGroupArgs.builder()
 *             .properties(BillingGroupPropertiesArgs.builder()
 *                 .description("This is my billing group")
 *                 .build())
 *             .tags(Map.of("terraform", "true"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IoT Billing Groups using the name. For example:
 * ```sh
 *  $ pulumi import aws:iot/billingGroup:BillingGroup example example
 * ```
 * @property name The name of the Billing Group.
 * @property properties The Billing Group properties. Defined below.
 * @property tags Key-value mapping of resource tags
 */
public data class BillingGroupArgs(
    public val name: Output<String>? = null,
    public val properties: Output<BillingGroupPropertiesArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.BillingGroupArgs> {
    override fun toJava(): com.pulumi.aws.iot.BillingGroupArgs =
        com.pulumi.aws.iot.BillingGroupArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [BillingGroupArgs].
 */
@PulumiTagMarker
public class BillingGroupArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var properties: Output<BillingGroupPropertiesArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the Billing Group.
     */
    @JvmName("hgmjuyainhymvqjb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The Billing Group properties. Defined below.
     */
    @JvmName("inracsqpcvhuovgu")
    public suspend fun properties(`value`: Output<BillingGroupPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Key-value mapping of resource tags
     */
    @JvmName("crdwthoxwrqqeyff")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the Billing Group.
     */
    @JvmName("umsqvfdtgascgtnw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The Billing Group properties. Defined below.
     */
    @JvmName("fhqpawknhknqjnji")
    public suspend fun properties(`value`: BillingGroupPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The Billing Group properties. Defined below.
     */
    @JvmName("bcjafojioovnfwvk")
    public suspend fun properties(argument: suspend BillingGroupPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = BillingGroupPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Key-value mapping of resource tags
     */
    @JvmName("eqqyioqpfyelfunm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags
     */
    @JvmName("jtyojxyddunenjxx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): BillingGroupArgs = BillingGroupArgs(
        name = name,
        properties = properties,
        tags = tags,
    )
}
