@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.CaCertificateArgs.builder
import com.pulumi.aws.iot.kotlin.inputs.CaCertificateRegistrationConfigArgs
import com.pulumi.aws.iot.kotlin.inputs.CaCertificateRegistrationConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates and manages an AWS IoT CA Certificate.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.tls.PrivateKey;
 * import com.pulumi.tls.PrivateKeyArgs;
 * import com.pulumi.tls.SelfSignedCert;
 * import com.pulumi.tls.SelfSignedCertArgs;
 * import com.pulumi.tls.inputs.SelfSignedCertSubjectArgs;
 * import com.pulumi.aws.iot.IotFunctions;
 * import com.pulumi.tls.CertRequest;
 * import com.pulumi.tls.CertRequestArgs;
 * import com.pulumi.tls.inputs.CertRequestSubjectArgs;
 * import com.pulumi.tls.LocallySignedCert;
 * import com.pulumi.tls.LocallySignedCertArgs;
 * import com.pulumi.aws.iot.CaCertificate;
 * import com.pulumi.aws.iot.CaCertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var caPrivateKey = new PrivateKey("caPrivateKey", PrivateKeyArgs.builder()
 *             .algorithm("RSA")
 *             .build());
 *         var caSelfSignedCert = new SelfSignedCert("caSelfSignedCert", SelfSignedCertArgs.builder()
 *             .privateKeyPem(caPrivateKey.privateKeyPem())
 *             .subject(SelfSignedCertSubjectArgs.builder()
 *                 .commonName("example.com")
 *                 .organization("ACME Examples, Inc")
 *                 .build())
 *             .validityPeriodHours(12)
 *             .allowedUses(
 *                 "key_encipherment",
 *                 "digital_signature",
 *                 "server_auth")
 *             .isCaCertificate(true)
 *             .build());
 *         var verificationPrivateKey = new PrivateKey("verificationPrivateKey", PrivateKeyArgs.builder()
 *             .algorithm("RSA")
 *             .build());
 *         final var exampleRegistrationCode = IotFunctions.getRegistrationCode();
 *         var verificationCertRequest = new CertRequest("verificationCertRequest", CertRequestArgs.builder()
 *             .privateKeyPem(verificationPrivateKey.privateKeyPem())
 *             .subject(CertRequestSubjectArgs.builder()
 *                 .commonName(exampleRegistrationCode.applyValue(getRegistrationCodeResult -> getRegistrationCodeResult.registrationCode()))
 *                 .build())
 *             .build());
 *         var verificationLocallySignedCert = new LocallySignedCert("verificationLocallySignedCert", LocallySignedCertArgs.builder()
 *             .certRequestPem(verificationCertRequest.certRequestPem())
 *             .caPrivateKeyPem(caPrivateKey.privateKeyPem())
 *             .caCertPem(caSelfSignedCert.certPem())
 *             .validityPeriodHours(12)
 *             .allowedUses(
 *                 "key_encipherment",
 *                 "digital_signature",
 *                 "server_auth")
 *             .build());
 *         var exampleCaCertificate = new CaCertificate("exampleCaCertificate", CaCertificateArgs.builder()
 *             .active(true)
 *             .caCertificatePem(caSelfSignedCert.certPem())
 *             .verificationCertificatePem(verificationLocallySignedCert.certPem())
 *             .allowAutoRegistration(true)
 *             .build());
 *     }
 * }
 * ```
 * @property active Boolean flag to indicate if the certificate should be active for device authentication.
 * @property allowAutoRegistration Boolean flag to indicate if the certificate should be active for device regisration.
 * @property caCertificatePem PEM encoded CA certificate.
 * @property certificateMode The certificate mode in which the CA will be registered. Valida values: `DEFAULT` and `SNI_ONLY`. Default: `DEFAULT`.
 * @property registrationConfig Information about the registration configuration. See below.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property verificationCertificatePem PEM encoded verification certificate containing the common name of a registration code. Review
 * [CreateVerificationCSR](https://docs.aws.amazon.com/iot/latest/developerguide/register-CA-cert.html). Reuired if `certificate_mode` is `DEFAULT`.
 */
public data class CaCertificateArgs(
    public val active: Output<Boolean>? = null,
    public val allowAutoRegistration: Output<Boolean>? = null,
    public val caCertificatePem: Output<String>? = null,
    public val certificateMode: Output<String>? = null,
    public val registrationConfig: Output<CaCertificateRegistrationConfigArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val verificationCertificatePem: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.CaCertificateArgs> {
    override fun toJava(): com.pulumi.aws.iot.CaCertificateArgs =
        com.pulumi.aws.iot.CaCertificateArgs.builder()
            .active(active?.applyValue({ args0 -> args0 }))
            .allowAutoRegistration(allowAutoRegistration?.applyValue({ args0 -> args0 }))
            .caCertificatePem(caCertificatePem?.applyValue({ args0 -> args0 }))
            .certificateMode(certificateMode?.applyValue({ args0 -> args0 }))
            .registrationConfig(
                registrationConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .verificationCertificatePem(verificationCertificatePem?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CaCertificateArgs].
 */
@PulumiTagMarker
public class CaCertificateArgsBuilder internal constructor() {
    private var active: Output<Boolean>? = null

    private var allowAutoRegistration: Output<Boolean>? = null

    private var caCertificatePem: Output<String>? = null

    private var certificateMode: Output<String>? = null

    private var registrationConfig: Output<CaCertificateRegistrationConfigArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var verificationCertificatePem: Output<String>? = null

    /**
     * @param value Boolean flag to indicate if the certificate should be active for device authentication.
     */
    @JvmName("ujswfbgvpaarkupm")
    public suspend fun active(`value`: Output<Boolean>) {
        this.active = value
    }

    /**
     * @param value Boolean flag to indicate if the certificate should be active for device regisration.
     */
    @JvmName("raxiaioaesvwdkot")
    public suspend fun allowAutoRegistration(`value`: Output<Boolean>) {
        this.allowAutoRegistration = value
    }

    /**
     * @param value PEM encoded CA certificate.
     */
    @JvmName("bembabfjopbjmnyr")
    public suspend fun caCertificatePem(`value`: Output<String>) {
        this.caCertificatePem = value
    }

    /**
     * @param value The certificate mode in which the CA will be registered. Valida values: `DEFAULT` and `SNI_ONLY`. Default: `DEFAULT`.
     */
    @JvmName("rmuexalpcwahqtso")
    public suspend fun certificateMode(`value`: Output<String>) {
        this.certificateMode = value
    }

    /**
     * @param value Information about the registration configuration. See below.
     */
    @JvmName("gxdikrwjnfpcrede")
    public suspend fun registrationConfig(`value`: Output<CaCertificateRegistrationConfigArgs>) {
        this.registrationConfig = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ubbailvrahlamjca")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value PEM encoded verification certificate containing the common name of a registration code. Review
     * [CreateVerificationCSR](https://docs.aws.amazon.com/iot/latest/developerguide/register-CA-cert.html). Reuired if `certificate_mode` is `DEFAULT`.
     */
    @JvmName("uijkpqpiplwmjkii")
    public suspend fun verificationCertificatePem(`value`: Output<String>) {
        this.verificationCertificatePem = value
    }

    /**
     * @param value Boolean flag to indicate if the certificate should be active for device authentication.
     */
    @JvmName("vjephefymsffpydh")
    public suspend fun active(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.active = mapped
    }

    /**
     * @param value Boolean flag to indicate if the certificate should be active for device regisration.
     */
    @JvmName("sqogdeugjssdgoyf")
    public suspend fun allowAutoRegistration(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowAutoRegistration = mapped
    }

    /**
     * @param value PEM encoded CA certificate.
     */
    @JvmName("jfbalupqtbjctwap")
    public suspend fun caCertificatePem(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.caCertificatePem = mapped
    }

    /**
     * @param value The certificate mode in which the CA will be registered. Valida values: `DEFAULT` and `SNI_ONLY`. Default: `DEFAULT`.
     */
    @JvmName("ptcbbuobnsqovbrg")
    public suspend fun certificateMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateMode = mapped
    }

    /**
     * @param value Information about the registration configuration. See below.
     */
    @JvmName("kriymqtvauxpfdjs")
    public suspend fun registrationConfig(`value`: CaCertificateRegistrationConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registrationConfig = mapped
    }

    /**
     * @param argument Information about the registration configuration. See below.
     */
    @JvmName("jgjecwfihqtlhwgj")
    public suspend
    fun registrationConfig(argument: suspend CaCertificateRegistrationConfigArgsBuilder.() -> Unit) {
        val toBeMapped = CaCertificateRegistrationConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.registrationConfig = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("khdtapniydirbyoj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lofbllicxxesysli")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value PEM encoded verification certificate containing the common name of a registration code. Review
     * [CreateVerificationCSR](https://docs.aws.amazon.com/iot/latest/developerguide/register-CA-cert.html). Reuired if `certificate_mode` is `DEFAULT`.
     */
    @JvmName("dncoywjcfqvegbmb")
    public suspend fun verificationCertificatePem(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.verificationCertificatePem = mapped
    }

    internal fun build(): CaCertificateArgs = CaCertificateArgs(
        active = active,
        allowAutoRegistration = allowAutoRegistration,
        caCertificatePem = caCertificatePem,
        certificateMode = certificateMode,
        registrationConfig = registrationConfig,
        tags = tags,
        verificationCertificatePem = verificationCertificatePem,
    )
}
