@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Certificate].
 */
@PulumiTagMarker
public class CertificateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CertificateArgs = CertificateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CertificateArgsBuilder.() -> Unit) {
        val builder = CertificateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Certificate {
        val builtJavaResource = com.pulumi.aws.iot.Certificate(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Certificate(builtJavaResource)
    }
}

/**
 * Creates and manages an AWS IoT certificate.
 * ## Example Usage
 * ### With CSR
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.Certificate;
 * import com.pulumi.aws.iot.CertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cert = new Certificate("cert", CertificateArgs.builder()
 *             .csr(Files.readString(Paths.get("/my/csr.pem")))
 *             .active(true)
 *             .build());
 *     }
 * }
 * ```
 * ### Without CSR
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.Certificate;
 * import com.pulumi.aws.iot.CertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cert = new Certificate("cert", CertificateArgs.builder()
 *             .active(true)
 *             .build());
 *     }
 * }
 * ```
 * ### From existing certificate without a CA
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.Certificate;
 * import com.pulumi.aws.iot.CertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cert = new Certificate("cert", CertificateArgs.builder()
 *             .certificatePem(Files.readString(Paths.get("/my/cert.pem")))
 *             .active(true)
 *             .build());
 *     }
 * }
 * ```
 */
public class Certificate internal constructor(
    override val javaResource: com.pulumi.aws.iot.Certificate,
) : KotlinCustomResource(javaResource, CertificateMapper) {
    /**
     * Boolean flag to indicate if the certificate should be active
     */
    public val active: Output<Boolean>
        get() = javaResource.active().applyValue({ args0 -> args0 })

    /**
     * The ARN of the created certificate.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The certificate ID of the CA certificate used to sign the certificate.
     */
    public val caCertificateId: Output<String>
        get() = javaResource.caCertificateId().applyValue({ args0 -> args0 })

    /**
     * The CA certificate for the certificate to be registered. If this is set, the CA needs to be registered with AWS IoT beforehand.
     */
    public val caPem: Output<String>?
        get() = javaResource.caPem().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The certificate to be registered. If `ca_pem` is unspecified, review
     * [RegisterCertificateWithoutCA](https://docs.aws.amazon.com/iot/latest/apireference/API_RegisterCertificateWithoutCA.html).
     * If `ca_pem` is specified, review
     * [RegisterCertificate](https://docs.aws.amazon.com/iot/latest/apireference/API_RegisterCertificate.html)
     * for more information on registering a certificate.
     */
    public val certificatePem: Output<String>
        get() = javaResource.certificatePem().applyValue({ args0 -> args0 })

    /**
     * The certificate signing request. Review
     * [CreateCertificateFromCsr](https://docs.aws.amazon.com/iot/latest/apireference/API_CreateCertificateFromCsr.html)
     * for more information on generating a certificate from a certificate signing request (CSR).
     * If none is specified both the certificate and keys will be generated, review [CreateKeysAndCertificate](https://docs.aws.amazon.com/iot/latest/apireference/API_CreateKeysAndCertificate.html)
     * for more information on generating keys and a certificate.
     */
    public val csr: Output<String>?
        get() = javaResource.csr().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * When neither CSR nor certificate is provided, the private key.
     */
    public val privateKey: Output<String>
        get() = javaResource.privateKey().applyValue({ args0 -> args0 })

    /**
     * When neither CSR nor certificate is provided, the public key.
     */
    public val publicKey: Output<String>
        get() = javaResource.publicKey().applyValue({ args0 -> args0 })
}

public object CertificateMapper : ResourceMapper<Certificate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iot.Certificate::class == javaResource::class

    override fun map(javaResource: Resource): Certificate = Certificate(
        javaResource as
            com.pulumi.aws.iot.Certificate,
    )
}

/**
 * @see [Certificate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Certificate].
 */
public suspend fun certificate(name: String, block: suspend CertificateResourceBuilder.() -> Unit):
    Certificate {
    val builder = CertificateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Certificate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun certificate(name: String): Certificate {
    val builder = CertificateResourceBuilder()
    builder.name(name)
    return builder.build()
}
