@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.CertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Creates and manages an AWS IoT certificate.
 * ## Example Usage
 * ### With CSR
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.Certificate;
 * import com.pulumi.aws.iot.CertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cert = new Certificate("cert", CertificateArgs.builder()
 *             .csr(Files.readString(Paths.get("/my/csr.pem")))
 *             .active(true)
 *             .build());
 *     }
 * }
 * ```
 * ### Without CSR
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.Certificate;
 * import com.pulumi.aws.iot.CertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cert = new Certificate("cert", CertificateArgs.builder()
 *             .active(true)
 *             .build());
 *     }
 * }
 * ```
 * ### From existing certificate without a CA
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.Certificate;
 * import com.pulumi.aws.iot.CertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cert = new Certificate("cert", CertificateArgs.builder()
 *             .certificatePem(Files.readString(Paths.get("/my/cert.pem")))
 *             .active(true)
 *             .build());
 *     }
 * }
 * ```
 * @property active Boolean flag to indicate if the certificate should be active
 * @property caPem The CA certificate for the certificate to be registered. If this is set, the CA needs to be registered with AWS IoT beforehand.
 * @property certificatePem The certificate to be registered. If `ca_pem` is unspecified, review
 * [RegisterCertificateWithoutCA](https://docs.aws.amazon.com/iot/latest/apireference/API_RegisterCertificateWithoutCA.html).
 * If `ca_pem` is specified, review
 * [RegisterCertificate](https://docs.aws.amazon.com/iot/latest/apireference/API_RegisterCertificate.html)
 * for more information on registering a certificate.
 * @property csr The certificate signing request. Review
 * [CreateCertificateFromCsr](https://docs.aws.amazon.com/iot/latest/apireference/API_CreateCertificateFromCsr.html)
 * for more information on generating a certificate from a certificate signing request (CSR).
 * If none is specified both the certificate and keys will be generated, review [CreateKeysAndCertificate](https://docs.aws.amazon.com/iot/latest/apireference/API_CreateKeysAndCertificate.html)
 * for more information on generating keys and a certificate.
 */
public data class CertificateArgs(
    public val active: Output<Boolean>? = null,
    public val caPem: Output<String>? = null,
    public val certificatePem: Output<String>? = null,
    public val csr: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.CertificateArgs> {
    override fun toJava(): com.pulumi.aws.iot.CertificateArgs =
        com.pulumi.aws.iot.CertificateArgs.builder()
            .active(active?.applyValue({ args0 -> args0 }))
            .caPem(caPem?.applyValue({ args0 -> args0 }))
            .certificatePem(certificatePem?.applyValue({ args0 -> args0 }))
            .csr(csr?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CertificateArgs].
 */
@PulumiTagMarker
public class CertificateArgsBuilder internal constructor() {
    private var active: Output<Boolean>? = null

    private var caPem: Output<String>? = null

    private var certificatePem: Output<String>? = null

    private var csr: Output<String>? = null

    /**
     * @param value Boolean flag to indicate if the certificate should be active
     */
    @JvmName("ghfpsxnbwdrdsxet")
    public suspend fun active(`value`: Output<Boolean>) {
        this.active = value
    }

    /**
     * @param value The CA certificate for the certificate to be registered. If this is set, the CA needs to be registered with AWS IoT beforehand.
     */
    @JvmName("hthmlaqdfopqhhik")
    public suspend fun caPem(`value`: Output<String>) {
        this.caPem = value
    }

    /**
     * @param value The certificate to be registered. If `ca_pem` is unspecified, review
     * [RegisterCertificateWithoutCA](https://docs.aws.amazon.com/iot/latest/apireference/API_RegisterCertificateWithoutCA.html).
     * If `ca_pem` is specified, review
     * [RegisterCertificate](https://docs.aws.amazon.com/iot/latest/apireference/API_RegisterCertificate.html)
     * for more information on registering a certificate.
     */
    @JvmName("bltrxqvaoxcehsda")
    public suspend fun certificatePem(`value`: Output<String>) {
        this.certificatePem = value
    }

    /**
     * @param value The certificate signing request. Review
     * [CreateCertificateFromCsr](https://docs.aws.amazon.com/iot/latest/apireference/API_CreateCertificateFromCsr.html)
     * for more information on generating a certificate from a certificate signing request (CSR).
     * If none is specified both the certificate and keys will be generated, review [CreateKeysAndCertificate](https://docs.aws.amazon.com/iot/latest/apireference/API_CreateKeysAndCertificate.html)
     * for more information on generating keys and a certificate.
     */
    @JvmName("xrcunahyqgyfmgxs")
    public suspend fun csr(`value`: Output<String>) {
        this.csr = value
    }

    /**
     * @param value Boolean flag to indicate if the certificate should be active
     */
    @JvmName("cppejqqfjlshsosj")
    public suspend fun active(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.active = mapped
    }

    /**
     * @param value The CA certificate for the certificate to be registered. If this is set, the CA needs to be registered with AWS IoT beforehand.
     */
    @JvmName("segnuaijwbrgyfwi")
    public suspend fun caPem(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.caPem = mapped
    }

    /**
     * @param value The certificate to be registered. If `ca_pem` is unspecified, review
     * [RegisterCertificateWithoutCA](https://docs.aws.amazon.com/iot/latest/apireference/API_RegisterCertificateWithoutCA.html).
     * If `ca_pem` is specified, review
     * [RegisterCertificate](https://docs.aws.amazon.com/iot/latest/apireference/API_RegisterCertificate.html)
     * for more information on registering a certificate.
     */
    @JvmName("bqfnpedbgfhxcjgq")
    public suspend fun certificatePem(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificatePem = mapped
    }

    /**
     * @param value The certificate signing request. Review
     * [CreateCertificateFromCsr](https://docs.aws.amazon.com/iot/latest/apireference/API_CreateCertificateFromCsr.html)
     * for more information on generating a certificate from a certificate signing request (CSR).
     * If none is specified both the certificate and keys will be generated, review [CreateKeysAndCertificate](https://docs.aws.amazon.com/iot/latest/apireference/API_CreateKeysAndCertificate.html)
     * for more information on generating keys and a certificate.
     */
    @JvmName("cjvfjsiqsaprkiaq")
    public suspend fun csr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.csr = mapped
    }

    internal fun build(): CertificateArgs = CertificateArgs(
        active = active,
        caPem = caPem,
        certificatePem = certificatePem,
        csr = csr,
    )
}
