@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.DomainConfigurationArgs.builder
import com.pulumi.aws.iot.kotlin.inputs.DomainConfigurationAuthorizerConfigArgs
import com.pulumi.aws.iot.kotlin.inputs.DomainConfigurationAuthorizerConfigArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.DomainConfigurationTlsConfigArgs
import com.pulumi.aws.iot.kotlin.inputs.DomainConfigurationTlsConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates and manages an AWS IoT domain configuration.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.DomainConfiguration;
 * import com.pulumi.aws.iot.DomainConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var iot = new DomainConfiguration("iot", DomainConfigurationArgs.builder()
 *             .domainName("iot.example.com")
 *             .serviceType("DATA")
 *             .serverCertificateArns(aws_acm_certificate.cert().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import domain configurations using the name. For example:
 * ```sh
 *  $ pulumi import aws:iot/domainConfiguration:DomainConfiguration example example
 * ```
 * @property authorizerConfig An object that specifies the authorization service for a domain. See below.
 * @property domainName Fully-qualified domain name.
 * @property name The name of the domain configuration. This value must be unique to a region.
 * @property serverCertificateArns The ARNs of the certificates that IoT passes to the device during the TLS handshake. Currently you can specify only one certificate ARN. This value is not required for Amazon Web Services-managed domains. When using a custom `domain_name`, the cert must include it.
 * @property serviceType The type of service delivered by the endpoint. Note: Amazon Web Services IoT Core currently supports only the `DATA` service type.
 * @property status
 * @property tags Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property tlsConfig An object that specifies the TLS configuration for a domain. See below.
 * @property validationCertificateArn The certificate used to validate the server certificate and prove domain name ownership. This certificate must be signed by a public certificate authority. This value is not required for Amazon Web Services-managed domains.
 */
public data class DomainConfigurationArgs(
    public val authorizerConfig: Output<DomainConfigurationAuthorizerConfigArgs>? = null,
    public val domainName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val serverCertificateArns: Output<List<String>>? = null,
    public val serviceType: Output<String>? = null,
    public val status: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tlsConfig: Output<DomainConfigurationTlsConfigArgs>? = null,
    public val validationCertificateArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.DomainConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.iot.DomainConfigurationArgs =
        com.pulumi.aws.iot.DomainConfigurationArgs.builder()
            .authorizerConfig(authorizerConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .serverCertificateArns(serverCertificateArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .serviceType(serviceType?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tlsConfig(tlsConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .validationCertificateArn(validationCertificateArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainConfigurationArgs].
 */
@PulumiTagMarker
public class DomainConfigurationArgsBuilder internal constructor() {
    private var authorizerConfig: Output<DomainConfigurationAuthorizerConfigArgs>? = null

    private var domainName: Output<String>? = null

    private var name: Output<String>? = null

    private var serverCertificateArns: Output<List<String>>? = null

    private var serviceType: Output<String>? = null

    private var status: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tlsConfig: Output<DomainConfigurationTlsConfigArgs>? = null

    private var validationCertificateArn: Output<String>? = null

    /**
     * @param value An object that specifies the authorization service for a domain. See below.
     */
    @JvmName("pcpqfmqnnkhbmusa")
    public suspend fun authorizerConfig(`value`: Output<DomainConfigurationAuthorizerConfigArgs>) {
        this.authorizerConfig = value
    }

    /**
     * @param value Fully-qualified domain name.
     */
    @JvmName("wjscfbqrwwvtqdjs")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value The name of the domain configuration. This value must be unique to a region.
     */
    @JvmName("gxamavlnuvmvscgj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The ARNs of the certificates that IoT passes to the device during the TLS handshake. Currently you can specify only one certificate ARN. This value is not required for Amazon Web Services-managed domains. When using a custom `domain_name`, the cert must include it.
     */
    @JvmName("udeffnhexvrttsho")
    public suspend fun serverCertificateArns(`value`: Output<List<String>>) {
        this.serverCertificateArns = value
    }

    @JvmName("vudrplvhittwbsnv")
    public suspend fun serverCertificateArns(vararg values: Output<String>) {
        this.serverCertificateArns = Output.all(values.asList())
    }

    /**
     * @param values The ARNs of the certificates that IoT passes to the device during the TLS handshake. Currently you can specify only one certificate ARN. This value is not required for Amazon Web Services-managed domains. When using a custom `domain_name`, the cert must include it.
     */
    @JvmName("ebpusxjyegughtkc")
    public suspend fun serverCertificateArns(values: List<Output<String>>) {
        this.serverCertificateArns = Output.all(values)
    }

    /**
     * @param value The type of service delivered by the endpoint. Note: Amazon Web Services IoT Core currently supports only the `DATA` service type.
     */
    @JvmName("rhxrrldciqpwhhue")
    public suspend fun serviceType(`value`: Output<String>) {
        this.serviceType = value
    }

    /**
     * @param value
     */
    @JvmName("eoexhrfbukyblbiy")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hkdiidsbujvroxxo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value An object that specifies the TLS configuration for a domain. See below.
     */
    @JvmName("lhhwwbgtpuacbjif")
    public suspend fun tlsConfig(`value`: Output<DomainConfigurationTlsConfigArgs>) {
        this.tlsConfig = value
    }

    /**
     * @param value The certificate used to validate the server certificate and prove domain name ownership. This certificate must be signed by a public certificate authority. This value is not required for Amazon Web Services-managed domains.
     */
    @JvmName("ceyhmbnxqvkbkomf")
    public suspend fun validationCertificateArn(`value`: Output<String>) {
        this.validationCertificateArn = value
    }

    /**
     * @param value An object that specifies the authorization service for a domain. See below.
     */
    @JvmName("eordtmhmodnrcktw")
    public suspend fun authorizerConfig(`value`: DomainConfigurationAuthorizerConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizerConfig = mapped
    }

    /**
     * @param argument An object that specifies the authorization service for a domain. See below.
     */
    @JvmName("eewklytgbtynthlr")
    public suspend
    fun authorizerConfig(argument: suspend DomainConfigurationAuthorizerConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DomainConfigurationAuthorizerConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.authorizerConfig = mapped
    }

    /**
     * @param value Fully-qualified domain name.
     */
    @JvmName("ytlgejcaaoxyorbe")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value The name of the domain configuration. This value must be unique to a region.
     */
    @JvmName("lloigfgnlwxvuljq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The ARNs of the certificates that IoT passes to the device during the TLS handshake. Currently you can specify only one certificate ARN. This value is not required for Amazon Web Services-managed domains. When using a custom `domain_name`, the cert must include it.
     */
    @JvmName("kwjdostesbyuhrdt")
    public suspend fun serverCertificateArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverCertificateArns = mapped
    }

    /**
     * @param values The ARNs of the certificates that IoT passes to the device during the TLS handshake. Currently you can specify only one certificate ARN. This value is not required for Amazon Web Services-managed domains. When using a custom `domain_name`, the cert must include it.
     */
    @JvmName("vswgmeadisfaaolw")
    public suspend fun serverCertificateArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverCertificateArns = mapped
    }

    /**
     * @param value The type of service delivered by the endpoint. Note: Amazon Web Services IoT Core currently supports only the `DATA` service type.
     */
    @JvmName("pjfudfnopcxrhcco")
    public suspend fun serviceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceType = mapped
    }

    /**
     * @param value
     */
    @JvmName("khhneiqfpohgxmwp")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ehohfehekeqmktmb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fcgkyqpomgaxskbq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value An object that specifies the TLS configuration for a domain. See below.
     */
    @JvmName("oxyvrsrgwhdxeqbn")
    public suspend fun tlsConfig(`value`: DomainConfigurationTlsConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tlsConfig = mapped
    }

    /**
     * @param argument An object that specifies the TLS configuration for a domain. See below.
     */
    @JvmName("fgbdbbjmcmgbuuwp")
    public suspend
    fun tlsConfig(argument: suspend DomainConfigurationTlsConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DomainConfigurationTlsConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tlsConfig = mapped
    }

    /**
     * @param value The certificate used to validate the server certificate and prove domain name ownership. This certificate must be signed by a public certificate authority. This value is not required for Amazon Web Services-managed domains.
     */
    @JvmName("ecofpqofxixjlxuv")
    public suspend fun validationCertificateArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationCertificateArn = mapped
    }

    internal fun build(): DomainConfigurationArgs = DomainConfigurationArgs(
        authorizerConfig = authorizerConfig,
        domainName = domainName,
        name = name,
        serverCertificateArns = serverCertificateArns,
        serviceType = serviceType,
        status = status,
        tags = tags,
        tlsConfig = tlsConfig,
        validationCertificateArn = validationCertificateArn,
    )
}
