@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [EventConfigurations].
 */
@PulumiTagMarker
public class EventConfigurationsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EventConfigurationsArgs = EventConfigurationsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EventConfigurationsArgsBuilder.() -> Unit) {
        val builder = EventConfigurationsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): EventConfigurations {
        val builtJavaResource = com.pulumi.aws.iot.EventConfigurations(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EventConfigurations(builtJavaResource)
    }
}

/**
 * Manages IoT event configurations.
 * > **NOTE:** Deleting this resource does not disable the event configurations, the resource in simply removed from state instead.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.EventConfigurations;
 * import com.pulumi.aws.iot.EventConfigurationsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EventConfigurations("example", EventConfigurationsArgs.builder()
 *             .eventConfigurations(Map.ofEntries(
 *                 Map.entry("CA_CERTIFICATE", false),
 *                 Map.entry("CERTIFICATE", true),
 *                 Map.entry("JOB", false),
 *                 Map.entry("JOB_EXECUTION", false),
 *                 Map.entry("POLICY", false),
 *                 Map.entry("THING", true),
 *                 Map.entry("THING_GROUP", false),
 *                 Map.entry("THING_GROUP_HIERARCHY", false),
 *                 Map.entry("THING_GROUP_MEMBERSHIP", false),
 *                 Map.entry("THING_TYPE", false),
 *                 Map.entry("THING_TYPE_ASSOCIATION", false)
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IoT Event Configurations using the AWS Region. For example:
 * ```sh
 *  $ pulumi import aws:iot/eventConfigurations:EventConfigurations example us-west-2
 * ```
 *
 */
public class EventConfigurations internal constructor(
    override val javaResource: com.pulumi.aws.iot.EventConfigurations,
) : KotlinCustomResource(javaResource, EventConfigurationsMapper) {
    /**
     * Map. The new event configuration values. You can use only these strings as keys: `THING_GROUP_HIERARCHY`, `THING_GROUP_MEMBERSHIP`, `THING_TYPE`, `THING_TYPE_ASSOCIATION`, `THING_GROUP`, `THING`, `POLICY`, `CA_CERTIFICATE`, `JOB_EXECUTION`, `CERTIFICATE`, `JOB`. Use boolean for values of mapping.
     */
    public val eventConfigurations: Output<Map<String, Boolean>>
        get() = javaResource.eventConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object EventConfigurationsMapper : ResourceMapper<EventConfigurations> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iot.EventConfigurations::class == javaResource::class

    override fun map(javaResource: Resource): EventConfigurations = EventConfigurations(
        javaResource
            as com.pulumi.aws.iot.EventConfigurations,
    )
}

/**
 * @see [EventConfigurations].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EventConfigurations].
 */
public suspend fun eventConfigurations(
    name: String,
    block: suspend EventConfigurationsResourceBuilder.() -> Unit,
): EventConfigurations {
    val builder = EventConfigurationsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EventConfigurations].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eventConfigurations(name: String): EventConfigurations {
    val builder = EventConfigurationsResourceBuilder()
    builder.name(name)
    return builder.build()
}
