@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.EventConfigurationsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages IoT event configurations.
 * > **NOTE:** Deleting this resource does not disable the event configurations, the resource in simply removed from state instead.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.EventConfigurations;
 * import com.pulumi.aws.iot.EventConfigurationsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EventConfigurations("example", EventConfigurationsArgs.builder()
 *             .eventConfigurations(Map.ofEntries(
 *                 Map.entry("CA_CERTIFICATE", false),
 *                 Map.entry("CERTIFICATE", true),
 *                 Map.entry("JOB", false),
 *                 Map.entry("JOB_EXECUTION", false),
 *                 Map.entry("POLICY", false),
 *                 Map.entry("THING", true),
 *                 Map.entry("THING_GROUP", false),
 *                 Map.entry("THING_GROUP_HIERARCHY", false),
 *                 Map.entry("THING_GROUP_MEMBERSHIP", false),
 *                 Map.entry("THING_TYPE", false),
 *                 Map.entry("THING_TYPE_ASSOCIATION", false)
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IoT Event Configurations using the AWS Region. For example:
 * ```sh
 *  $ pulumi import aws:iot/eventConfigurations:EventConfigurations example us-west-2
 * ```
 * @property eventConfigurations Map. The new event configuration values. You can use only these strings as keys: `THING_GROUP_HIERARCHY`, `THING_GROUP_MEMBERSHIP`, `THING_TYPE`, `THING_TYPE_ASSOCIATION`, `THING_GROUP`, `THING`, `POLICY`, `CA_CERTIFICATE`, `JOB_EXECUTION`, `CERTIFICATE`, `JOB`. Use boolean for values of mapping.
 */
public data class EventConfigurationsArgs(
    public val eventConfigurations: Output<Map<String, Boolean>>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.EventConfigurationsArgs> {
    override fun toJava(): com.pulumi.aws.iot.EventConfigurationsArgs =
        com.pulumi.aws.iot.EventConfigurationsArgs.builder()
            .eventConfigurations(
                eventConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [EventConfigurationsArgs].
 */
@PulumiTagMarker
public class EventConfigurationsArgsBuilder internal constructor() {
    private var eventConfigurations: Output<Map<String, Boolean>>? = null

    /**
     * @param value Map. The new event configuration values. You can use only these strings as keys: `THING_GROUP_HIERARCHY`, `THING_GROUP_MEMBERSHIP`, `THING_TYPE`, `THING_TYPE_ASSOCIATION`, `THING_GROUP`, `THING`, `POLICY`, `CA_CERTIFICATE`, `JOB_EXECUTION`, `CERTIFICATE`, `JOB`. Use boolean for values of mapping.
     */
    @JvmName("gxmagtoxdtsdpglf")
    public suspend fun eventConfigurations(`value`: Output<Map<String, Boolean>>) {
        this.eventConfigurations = value
    }

    /**
     * @param value Map. The new event configuration values. You can use only these strings as keys: `THING_GROUP_HIERARCHY`, `THING_GROUP_MEMBERSHIP`, `THING_TYPE`, `THING_TYPE_ASSOCIATION`, `THING_GROUP`, `THING`, `POLICY`, `CA_CERTIFICATE`, `JOB_EXECUTION`, `CERTIFICATE`, `JOB`. Use boolean for values of mapping.
     */
    @JvmName("qnvqruiixtlvqfsc")
    public suspend fun eventConfigurations(`value`: Map<String, Boolean>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventConfigurations = mapped
    }

    /**
     * @param values Map. The new event configuration values. You can use only these strings as keys: `THING_GROUP_HIERARCHY`, `THING_GROUP_MEMBERSHIP`, `THING_TYPE`, `THING_TYPE_ASSOCIATION`, `THING_GROUP`, `THING`, `POLICY`, `CA_CERTIFICATE`, `JOB_EXECUTION`, `CERTIFICATE`, `JOB`. Use boolean for values of mapping.
     */
    @JvmName("rlweemnysbyforcv")
    public fun eventConfigurations(vararg values: Pair<String, Boolean>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventConfigurations = mapped
    }

    internal fun build(): EventConfigurationsArgs = EventConfigurationsArgs(
        eventConfigurations = eventConfigurations,
    )
}
